/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.java.client.network.http.internal;

import com.apollographql.apollo.api.Adapters;
import com.apollographql.apollo.api.CustomScalarAdapters;
import com.apollographql.apollo.api.http.HttpBody;
import com.apollographql.apollo.api.http.HttpHeader;
import com.apollographql.apollo.api.http.HttpKt;
import com.apollographql.apollo.api.http.HttpMethod;
import com.apollographql.apollo.api.http.HttpRequest;
import com.apollographql.apollo.api.http.HttpResponse;
import com.apollographql.apollo.api.json.BufferedSinkJsonWriter;
import com.apollographql.apollo.api.json.BufferedSourceJsonReader;
import com.apollographql.apollo.api.json.JsonReader;
import com.apollographql.apollo.api.json.JsonWriter;
import com.apollographql.apollo.exception.ApolloHttpException;
import com.apollographql.apollo.exception.ApolloNetworkException;
import com.apollographql.java.client.network.http.HttpCallback;
import com.apollographql.java.client.network.http.HttpInterceptor;
import com.apollographql.java.client.network.http.HttpInterceptorChain;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;

public class BatchingHttpInterceptor
implements HttpInterceptor {
    private final long batchIntervalMillis;
    private final int maxBatchSize;
    private final boolean exposeErrorBody;
    @NotNull
    private HttpInterceptorChain interceptorChain;
    private final List<PendingRequest> pendingRequests = new ArrayList<PendingRequest>();
    private final ExecutorService executor = Executors.newSingleThreadExecutor();

    public BatchingHttpInterceptor(long batchIntervalMillis, int maxBatchSize, boolean exposeErrorBody) {
        this.batchIntervalMillis = batchIntervalMillis;
        this.maxBatchSize = maxBatchSize;
        this.exposeErrorBody = exposeErrorBody;
    }

    private void scheduleExecutePendingRequests() {
        this.executor.execute(() -> {
            try {
                Thread.sleep(this.batchIntervalMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.executePendingRequests();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void intercept(@NotNull HttpRequest request, @NotNull HttpInterceptorChain chain, @NotNull HttpCallback callback) {
        int pendingRequestsSize;
        boolean canBeBatched;
        String canBeBatchedHeader = HttpKt.get((List)request.getHeaders(), (String)"X-APOLLO-CAN-BE-BATCHED");
        boolean bl = canBeBatched = canBeBatchedHeader == null || Boolean.parseBoolean(canBeBatchedHeader);
        if (!canBeBatched) {
            List headers = request.getHeaders().stream().filter(header -> !"X-APOLLO-CAN-BE-BATCHED".equals(header.getName())).collect(Collectors.toList());
            chain.proceed(request.newBuilder().headers(headers).build(), callback);
            return;
        }
        this.interceptorChain = chain;
        PendingRequest pendingRequest = new PendingRequest(request, callback);
        List<PendingRequest> list = this.pendingRequests;
        synchronized (list) {
            this.pendingRequests.add(pendingRequest);
            pendingRequestsSize = this.pendingRequests.size();
        }
        if (pendingRequestsSize >= this.maxBatchSize) {
            this.executePendingRequests();
        } else {
            this.scheduleExecutePendingRequests();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executePendingRequests() {
        ArrayList<PendingRequest> pending;
        List<PendingRequest> list = this.pendingRequests;
        synchronized (list) {
            pending = new ArrayList<PendingRequest>(this.pendingRequests);
            this.pendingRequests.clear();
        }
        if (pending.isEmpty()) {
            return;
        }
        HttpRequest firstRequest = ((PendingRequest)pending.get(0)).request;
        final List allBodies = pending.stream().map(p -> ((PendingRequest)p).request.getBody()).collect(Collectors.toList());
        List commonHeaders = pending.stream().map(p -> ((PendingRequest)p).request.getHeaders()).reduce((acc, headers) -> {
            ArrayList<HttpHeader> common = new ArrayList<HttpHeader>();
            for (HttpHeader accHeader : acc) {
                String headerValue = HttpKt.get((List)headers, (String)accHeader.getName());
                if (headerValue == null || !headerValue.equals(accHeader.getValue())) continue;
                common.add(accHeader);
            }
            return common;
        }).get();
        commonHeaders = commonHeaders.stream().filter(header -> !"X-APOLLO-CAN-BE-BATCHED".equals(header.getName())).collect(Collectors.toList());
        HttpBody body = new HttpBody(){

            @NotNull
            public String getContentType() {
                return "application/json";
            }

            public long getContentLength() {
                return -1L;
            }

            public void writeTo(@NotNull BufferedSink bufferedSink) {
                BufferedSinkJsonWriter writer = new BufferedSinkJsonWriter(bufferedSink);
                writer.beginArray();
                for (HttpBody requestBody : allBodies) {
                    Buffer buffer = new Buffer();
                    requestBody.writeTo((BufferedSink)buffer);
                    writer.jsonValue(buffer.readUtf8());
                }
                writer.endArray();
            }
        };
        HttpRequest request = new HttpRequest.Builder(HttpMethod.Post, firstRequest.getUrl()).body(body).headers(commonHeaders).build();
        this.interceptorChain.proceed(request, new HttpCallback(){

            @Override
            public void onResponse(@NotNull HttpResponse response) {
                try {
                    Object fromJson;
                    if (response.getStatusCode() < 200 || response.getStatusCode() > 299) {
                        BufferedSource maybeBody;
                        BufferedSource responseBody = response.getBody();
                        if (BatchingHttpInterceptor.this.exposeErrorBody) {
                            maybeBody = responseBody;
                        } else {
                            if (responseBody != null) {
                                try {
                                    responseBody.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            maybeBody = null;
                        }
                        throw new ApolloNetworkException(null, (Object)new ApolloHttpException(response.getStatusCode(), response.getHeaders(), maybeBody, "HTTP error " + response.getStatusCode() + " while executing batched query", null));
                    }
                    BufferedSource responseBody = response.getBody();
                    if (responseBody == null) {
                        throw new ApolloNetworkException("null body when executing batched query", null);
                    }
                    try {
                        fromJson = Adapters.AnyAdapter.fromJson((JsonReader)new BufferedSourceJsonReader(responseBody), CustomScalarAdapters.Empty);
                    }
                    catch (IOException e) {
                        throw new ApolloNetworkException("failed to parse batched response JSON", (Object)e);
                    }
                    if (!(fromJson instanceof List)) {
                        throw new ApolloNetworkException("batched query response is not a list when executing batched query", null);
                    }
                    List list = (List)fromJson;
                    if (list.size() != pending.size()) {
                        throw new ApolloNetworkException("batched query response count (" + list.size() + ") does not match the requested queries (" + pending.size() + ")", null);
                    }
                    ArrayList<ByteString> result = new ArrayList<ByteString>();
                    for (Object o : list) {
                        if (o == null) {
                            throw new ApolloNetworkException("batched query response contains a null item", null);
                        }
                        result.add(BatchingHttpInterceptor.toJsonByteString(o));
                    }
                    for (int i = 0; i < result.size(); ++i) {
                        ((PendingRequest)pending.get(i)).onResponse(new HttpResponse.Builder(200).body((ByteString)result.get(i)).build());
                    }
                }
                catch (ApolloNetworkException e) {
                    for (PendingRequest p : pending) {
                        p.onFailure(e);
                    }
                }
            }

            @Override
            public void onFailure(@NotNull ApolloNetworkException exception) {
                for (PendingRequest p : pending) {
                    p.onFailure(exception);
                }
            }
        });
    }

    private static ByteString toJsonByteString(Object o) {
        Buffer buffer = new Buffer();
        BufferedSinkJsonWriter writer = new BufferedSinkJsonWriter((BufferedSink)buffer);
        try {
            Adapters.AnyAdapter.toJson((JsonWriter)writer, CustomScalarAdapters.Empty, o);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buffer.readByteString();
    }

    private static class PendingRequest
    implements HttpCallback {
        @NotNull
        private final HttpRequest request;
        @NotNull
        private final HttpCallback callback;

        private PendingRequest(@NotNull HttpRequest request, @NotNull HttpCallback callback) {
            this.request = request;
            this.callback = callback;
        }

        @Override
        public void onResponse(@NotNull HttpResponse response) {
            this.callback.onResponse(response);
        }

        @Override
        public void onFailure(@NotNull ApolloNetworkException exception) {
            this.callback.onFailure(exception);
        }
    }
}

