/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.java.client.network.http.internal;

import com.apollographql.apollo.api.http.HttpMethod;
import com.apollographql.apollo.api.http.HttpRequest;
import com.apollographql.apollo.api.http.HttpResponse;
import com.apollographql.apollo.exception.ApolloNetworkException;
import com.apollographql.java.client.ApolloDisposable;
import com.apollographql.java.client.network.http.HttpCallback;
import com.apollographql.java.client.network.http.HttpEngine;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OkHttpHttpEngine
implements HttpEngine {
    private final Call.Factory okHttpCallFactory;

    public OkHttpHttpEngine(Call.Factory okHttpCallFactory) {
        this.okHttpCallFactory = okHttpCallFactory;
    }

    public OkHttpHttpEngine(long connectTimeout, long readTimeout) {
        this.okHttpCallFactory = new OkHttpClient.Builder().connectTimeout(connectTimeout, TimeUnit.MILLISECONDS).readTimeout(readTimeout, TimeUnit.MILLISECONDS).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(final @NotNull HttpRequest request, @NotNull HttpCallback callback, @NotNull ApolloDisposable disposable) {
        Request.Builder okHttpRequestBuilder = new Request.Builder().url(request.getUrl());
        request.getHeaders().forEach(httpHeader -> okHttpRequestBuilder.addHeader(httpHeader.getName(), httpHeader.getValue()));
        if (request.getMethod() == HttpMethod.Post) {
            okHttpRequestBuilder.post(new RequestBody(){

                @Nullable
                public MediaType contentType() {
                    return MediaType.parse((String)request.getBody().getContentType());
                }

                public long contentLength() {
                    return request.getBody().getContentLength();
                }

                public void writeTo(@NotNull BufferedSink bufferedSink) throws IOException {
                    request.getBody().writeTo(bufferedSink);
                }
            });
        }
        Call okHttpCall = this.okHttpCallFactory.newCall(okHttpRequestBuilder.build());
        ApolloDisposable.Listener listener = () -> ((Call)okHttpCall).cancel();
        disposable.addListener(listener);
        try {
            if (disposable.isDisposed()) {
                return;
            }
            Response okHttpResponse = okHttpCall.execute();
            if (disposable.isDisposed()) {
                return;
            }
            HttpResponse.Builder httpResponseBuilder = new HttpResponse.Builder(okHttpResponse.code()).body(okHttpResponse.body().source());
            okHttpResponse.headers().forEach(pair -> httpResponseBuilder.addHeader((String)pair.getFirst(), (String)pair.getSecond()));
            callback.onResponse(httpResponseBuilder.build());
        }
        catch (IOException e) {
            if (disposable.isDisposed()) {
                return;
            }
            callback.onFailure(new ApolloNetworkException("Network error", (Object)e));
        }
        finally {
            disposable.removeListener(listener);
        }
    }

    @Override
    public void dispose() {
    }
}

