/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.java.client.network.ws;

import com.apollographql.apollo.api.ApolloRequest;
import com.apollographql.apollo.api.ApolloResponse;
import com.apollographql.apollo.api.CustomScalarAdapters;
import com.apollographql.apollo.api.ExecutionContext;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.Operations;
import com.apollographql.apollo.api.http.HttpHeader;
import com.apollographql.apollo.api.json.JsonReader;
import com.apollographql.apollo.api.json.MapJsonReader;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.exception.ApolloNetworkException;
import com.apollographql.apollo.exception.SubscriptionOperationException;
import com.apollographql.java.client.ApolloCallback;
import com.apollographql.java.client.ApolloDisposable;
import com.apollographql.java.client.network.NetworkTransport;
import com.apollographql.java.client.network.ws.WebSocketConnection;
import com.apollographql.java.client.network.ws.protocol.WsProtocol;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import okhttp3.WebSocket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebSocketNetworkTransport
implements NetworkTransport {
    private WebSocket.Factory webSocketFactory;
    private String serverUrl;
    private WsProtocol.Factory wsProtocolFactory;
    private List<HttpHeader> headers;
    private ReopenWhen reopenWhen;
    private Executor executor;
    private long idleTimeoutMillis;
    private Map<String, SubscriptionInfo> activeSubscriptions = Collections.synchronizedMap(new HashMap());
    private AtomicReference<WsProtocol> wsProtocol = new AtomicReference();
    private final WsProtocol.Listener listener = new WsProtocol.Listener(){
        private int reopenAttempt = -1;

        @Override
        public void operationResponse(String id, Map<String, Object> payload) {
            SubscriptionInfo subscriptionInfo = (SubscriptionInfo)WebSocketNetworkTransport.this.activeSubscriptions.get(id);
            if (subscriptionInfo == null) {
                return;
            }
            ApolloRequest request = subscriptionInfo.request;
            CustomScalarAdapters customScalarAdapters = (CustomScalarAdapters)request.getExecutionContext().get((ExecutionContext.Key)CustomScalarAdapters.Key);
            MapJsonReader jsonReader = new MapJsonReader(payload);
            ApolloResponse apolloResponse = Operations.toApolloResponse((JsonReader)jsonReader, (Operation)request.getOperation(), (UUID)request.getRequestUuid(), (CustomScalarAdapters)customScalarAdapters, null);
            subscriptionInfo.callback.onResponse(apolloResponse);
        }

        @Override
        public void operationError(String id, Map<String, Object> payload) {
            SubscriptionInfo subscriptionInfo = (SubscriptionInfo)WebSocketNetworkTransport.this.activeSubscriptions.get(id);
            if (subscriptionInfo == null) {
                return;
            }
            ApolloRequest request = subscriptionInfo.request;
            subscriptionInfo.callback.onResponse(new ApolloResponse.Builder(request.getOperation(), request.getRequestUuid()).exception((ApolloException)new SubscriptionOperationException(request.getOperation().name(), payload)).build());
            WebSocketNetworkTransport.this.disposeSubscription(id);
        }

        @Override
        public void operationComplete(String id) {
            WebSocketNetworkTransport.this.disposeSubscription(id);
        }

        @Override
        public void generalError(Map<String, Object> payload) {
            System.out.println("Received general error: " + payload);
        }

        @Override
        public void networkError(Throwable cause) {
            WebSocketNetworkTransport.this.wsProtocol.set(null);
            ++this.reopenAttempt;
            if (WebSocketNetworkTransport.this.reopenWhen.reopenWhen(cause, this.reopenAttempt)) {
                WsProtocol runningWsProtocol = WebSocketNetworkTransport.this.ensureWsProtocolRunning();
                if (runningWsProtocol != null) {
                    this.reopenAttempt = -1;
                    ArrayList activeSubscriptionList = new ArrayList(WebSocketNetworkTransport.this.activeSubscriptions.values());
                    for (SubscriptionInfo subscriptionInfo : activeSubscriptionList) {
                        runningWsProtocol.startOperation(subscriptionInfo.request);
                    }
                }
            } else {
                this.reopenAttempt = -1;
                ApolloNetworkException networkException = new ApolloNetworkException("Network error", (Object)cause);
                ArrayList activeSubscriptionList = new ArrayList(WebSocketNetworkTransport.this.activeSubscriptions.values());
                WebSocketNetworkTransport.this.activeSubscriptions.clear();
                for (SubscriptionInfo subscriptionInfo : activeSubscriptionList) {
                    subscriptionInfo.callback.onResponse(new ApolloResponse.Builder(subscriptionInfo.request.getOperation(), subscriptionInfo.request.getRequestUuid()).exception((ApolloException)networkException).build());
                    subscriptionInfo.disposable.dispose();
                }
                WebSocketNetworkTransport.this.stopWsProtocolIfNoMoreSubscriptions();
            }
        }
    };

    public WebSocketNetworkTransport(WebSocket.Factory webSocketFactory, WsProtocol.Factory wsProtocolFactory, String serverUrl, List<HttpHeader> headers, ReopenWhen reopenWhen, Executor executor, long idleTimeoutMillis) {
        this.webSocketFactory = webSocketFactory;
        this.serverUrl = serverUrl;
        this.wsProtocolFactory = wsProtocolFactory;
        this.headers = headers;
        this.reopenWhen = reopenWhen;
        this.executor = executor;
        this.idleTimeoutMillis = idleTimeoutMillis;
    }

    @Override
    public <D extends Operation.Data> void execute(@NotNull ApolloRequest<D> request, @NotNull ApolloCallback<D> callback, ApolloDisposable disposable) {
        SubscriptionInfo subscriptionInfo = new SubscriptionInfo(request, callback, disposable);
        String id = request.getRequestUuid().toString();
        this.activeSubscriptions.put(id, subscriptionInfo);
        disposable.addListener(() -> {
            if (this.activeSubscriptions.containsKey(id)) {
                WsProtocol curWsProtocol = this.wsProtocol.get();
                if (curWsProtocol != null) {
                    curWsProtocol.stopOperation(request);
                }
                this.disposeSubscription(id);
            }
        });
        WsProtocol runningWsProtocol = this.ensureWsProtocolRunning();
        if (runningWsProtocol != null) {
            runningWsProtocol.startOperation(request);
        }
    }

    @Override
    public void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private WsProtocol ensureWsProtocolRunning() {
        WebSocketNetworkTransport webSocketNetworkTransport = this;
        synchronized (webSocketNetworkTransport) {
            WsProtocol curWsProtocol = this.wsProtocol.get();
            if (curWsProtocol == null) {
                WebSocketConnection webSocket;
                try {
                    webSocket = this.openWebSocket();
                }
                catch (Throwable e) {
                    this.listener.networkError(e);
                    return null;
                }
                WsProtocol newWsProtocol = this.wsProtocolFactory.create(webSocket, this.listener);
                this.wsProtocol.set(newWsProtocol);
                newWsProtocol.connectionInit();
                this.executor.execute(newWsProtocol::run);
                return newWsProtocol;
            }
            return curWsProtocol;
        }
    }

    private WebSocketConnection openWebSocket() throws Throwable {
        ArrayList<HttpHeader> headers = new ArrayList<HttpHeader>(this.headers);
        if (headers.stream().noneMatch(it -> it.getName().equals("Sec-WebSocket-Protocol"))) {
            headers.add(new HttpHeader("Sec-WebSocket-Protocol", this.wsProtocolFactory.getName()));
        }
        WebSocketConnection webSocketConnection = new WebSocketConnection(this.webSocketFactory, this.serverUrl, headers);
        webSocketConnection.open();
        return webSocketConnection;
    }

    private void scheduleStopWsProtocolIfNoMoreSubscriptions() {
        this.executor.execute(() -> {
            try {
                Thread.sleep(this.idleTimeoutMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.stopWsProtocolIfNoMoreSubscriptions();
        });
    }

    private void stopWsProtocolIfNoMoreSubscriptions() {
        WsProtocol curWsProtocol = this.wsProtocol.get();
        if (this.activeSubscriptions.isEmpty() && curWsProtocol != null) {
            curWsProtocol.close();
            this.wsProtocol.set(null);
        }
    }

    private void disposeSubscription(String id) {
        SubscriptionInfo subscriptionInfo = this.activeSubscriptions.get(id);
        if (subscriptionInfo == null) {
            return;
        }
        this.activeSubscriptions.remove(id);
        subscriptionInfo.disposable.dispose();
        this.scheduleStopWsProtocolIfNoMoreSubscriptions();
    }

    public static interface ReopenWhen {
        public boolean reopenWhen(Throwable var1, long var2);
    }

    private static class SubscriptionInfo {
        private ApolloRequest<?> request;
        private ApolloCallback<?> callback;
        private ApolloDisposable disposable;

        public SubscriptionInfo(@NotNull ApolloRequest<?> request, @NotNull ApolloCallback<?> callback, ApolloDisposable disposable) {
            this.request = request;
            this.callback = callback;
            this.disposable = disposable;
        }
    }
}

