/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.java.client.network.ws.protocol;

import com.apollographql.apollo.api.ApolloRequest;
import com.apollographql.apollo.api.ImmutableMapBuilder;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.http.DefaultHttpRequestComposer;
import com.apollographql.java.client.network.ws.WebSocketConnection;
import com.apollographql.java.client.network.ws.protocol.WsProtocol;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class GraphQLWsProtocol
extends WsProtocol {
    private Supplier<Map<String, Object>> connectionPayload;
    private WsProtocol.WsFrameType frameType;
    private Map<String, Object> pingPayload;
    private Map<String, Object> pongPayload;
    private long connectionAcknowledgeTimeoutMs;
    private long pingIntervalMillis;
    private ScheduledExecutorService pingExecutor = Executors.newSingleThreadScheduledExecutor();

    public GraphQLWsProtocol(WebSocketConnection webSocketConnection, WsProtocol.Listener listener, Supplier<Map<String, Object>> connectionPayload, WsProtocol.WsFrameType frameType, Map<String, Object> pingPayload, Map<String, Object> pongPayload, long connectionAcknowledgeTimeoutMs, long pingIntervalMillis) {
        super(webSocketConnection, listener);
        this.connectionPayload = connectionPayload;
        this.frameType = frameType;
        this.pingPayload = pingPayload;
        this.pongPayload = pongPayload;
        this.connectionAcknowledgeTimeoutMs = connectionAcknowledgeTimeoutMs;
        this.pingIntervalMillis = pingIntervalMillis;
    }

    @Override
    public void connectionInit() {
        Map message = new ImmutableMapBuilder().put((Object)"type", (Object)"connection_init").build();
        Map<String, Object> payload = this.connectionPayload.get();
        if (payload != null) {
            message.put("payload", payload);
        }
        this.sendMessageMap(message, this.frameType);
        Map<String, Object> map = this.receiveMessageMap(this.connectionAcknowledgeTimeoutMs);
        if (map == null) {
            this.listener.networkError(new IOException("Connection closed or timeout while waiting for connection_ack"));
        } else {
            Object type = map.get("type");
            if ("connection_error".equals(type)) {
                this.listener.networkError(new IOException("connection_error received " + map));
            } else if (!"connection_ack".equals(type)) {
                System.out.println("unknown graphql-transport-ws message while waiting for connection_ack: " + type);
            }
        }
    }

    @Override
    public void handleServerMessage(Map<String, Object> messageMap) {
        String type;
        switch (type = (String)messageMap.get("type")) {
            case "next": {
                this.listener.operationResponse((String)messageMap.get("id"), (Map)messageMap.get("payload"));
                break;
            }
            case "error": {
                this.listener.operationError((String)messageMap.get("id"), (Map)messageMap.get("payload"));
                break;
            }
            case "complete": {
                this.listener.operationComplete((String)messageMap.get("id"));
                break;
            }
            case "ping": {
                Map map = new ImmutableMapBuilder().put((Object)"type", (Object)"pong").build();
                if (this.pongPayload != null) {
                    map.put("payload", this.pongPayload);
                }
                this.sendMessageMap(map, this.frameType);
                break;
            }
            case "pong": {
                break;
            }
        }
    }

    @Override
    public <D extends Operation.Data> void startOperation(ApolloRequest<D> request) {
        this.sendMessageMap(new ImmutableMapBuilder().put((Object)"type", (Object)"subscribe").put((Object)"id", (Object)request.getRequestUuid().toString()).put((Object)"payload", (Object)DefaultHttpRequestComposer.Companion.composePayload(request)).build(), this.frameType);
    }

    @Override
    public <D extends Operation.Data> void stopOperation(ApolloRequest<D> request) {
        this.sendMessageMap(new ImmutableMapBuilder().put((Object)"type", (Object)"complete").put((Object)"id", (Object)request.getRequestUuid().toString()).build(), this.frameType);
    }

    @Override
    public void run() {
        if (this.pingIntervalMillis > 0L) {
            this.pingExecutor.scheduleWithFixedDelay(() -> {
                Map map = new ImmutableMapBuilder().put((Object)"type", (Object)"ping").build();
                if (this.pingPayload != null) {
                    map.put("payload", this.pingPayload);
                }
                this.sendMessageMap(map, this.frameType);
            }, this.pingIntervalMillis, this.pingIntervalMillis, TimeUnit.MILLISECONDS);
        }
        super.run();
    }

    public static class Factory
    implements WsProtocol.Factory {
        private Supplier<Map<String, Object>> connectionPayload;
        private WsProtocol.WsFrameType frameType;
        private Map<String, Object> pingPayload;
        private Map<String, Object> pongPayload;
        private long connectionAcknowledgeTimeoutMs;
        private long pingIntervalMillis;

        public Factory() {
            this(() -> null, WsProtocol.WsFrameType.Text, null, null, 60000L, -1L);
        }

        public Factory(Supplier<Map<String, Object>> connectionPayload, WsProtocol.WsFrameType frameType, Map<String, Object> pingPayload, Map<String, Object> pongPayload, long connectionAcknowledgeTimeoutMs, long pingIntervalMillis) {
            this.connectionPayload = connectionPayload;
            this.frameType = frameType;
            this.pingPayload = pingPayload;
            this.pongPayload = pongPayload;
            this.connectionAcknowledgeTimeoutMs = connectionAcknowledgeTimeoutMs;
            this.pingIntervalMillis = pingIntervalMillis;
        }

        @Override
        public String getName() {
            return "graphql-transport-ws";
        }

        @Override
        public WsProtocol create(WebSocketConnection webSocketConnection, WsProtocol.Listener listener) {
            return new GraphQLWsProtocol(webSocketConnection, listener, this.connectionPayload, this.frameType, this.pingPayload, this.pongPayload, this.connectionAcknowledgeTimeoutMs, this.pingIntervalMillis);
        }
    }
}

