package common.base;

/**
 * Created by apolunor on 2017/5/5.
 */

public interface ArrayPool<T> {
    /**
     * @return An instance from the pool if such, null otherwise.
     */
    T acquire(int len);

    /**
     * Release an instance to the pool.
     *
     * @param instance The instance to release.
     * @return Whether the instance was put in the pool.
     *
     * @throws IllegalStateException If the instance is already in the pool.
     */
    boolean release(T instance);

    /**
     * Evict all items from the memory cache.
     */
    void clearMemory();

    /**
     * Trim the memory cache to the appropriate level. Typically called on the callback onTrimMemory.
     *
     * @param level This integer represents a trim level as specified in {@link
     *              android.content.ComponentCallbacks2}.
     */
    void trimMemory(int level);
}
