package common.base;

/**
 * Created by apolunor on 2017/4/20.
 */

public interface Cache<K, V> {

    void initialize();

    V get(K key);

    void put(K key, V value);

    void remove(K key);

    /**
     * Evict all items from the memory cache.
     */
    void clearMemory();

    /**
     * Trim the memory cache to the appropriate level. Typically called on the callback onTrimMemory.
     *
     * @param level This integer represents a trim level as specified in {@link
     *              android.content.ComponentCallbacks2}.
     */
    void trimMemory(int level);

}
