package common.base;

import android.content.Context;
import android.content.res.Configuration;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;

import static android.util.Log.ERROR;
import static android.util.Log.VERBOSE;

/**
 * Created by apolunor on 2017/5/14.
 */

public final class Common implements Service {
    private Context mContext;

    private boolean mDebug = true;
    private boolean mGlobalCatchError = false;

    private static final Singleton<Common> INSTANCE = new Singleton<Common>() {
        protected Common create() {
            return new Common();
        }
    };

    public static final Common getInstance() {
        return INSTANCE.get();
    }

    private Common() {
    }

    @Override
    @MainThread
    public void initialize(@NonNull Context context) {
        mContext = context.getApplicationContext();
        mContext.registerComponentCallbacks(this);
        SystemAsyncTaskPatch.patch();
        LogHelper.initialize(new LogHelper.Default(), "", mDebug ? VERBOSE : ERROR);
        Report.initialize(new Report.Empty());
    }

    @Override
    public void onTrimMemory(int level) {

    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {

    }

    @Override
    public void onLowMemory() {

    }

    public boolean isDebug() {
        return mDebug;
    }

    public boolean isGlobalCatchError() {
        return mGlobalCatchError;
    }
}
