package common.base;

import android.support.annotation.NonNull;

import java.util.Map;

/**
 * Created by apolunor on 2017/5/15.
 */

public final class Report {

    public interface Reporter {
        void report(String key);

        void report(String key, Map<String, Object> map);
    }

    private static Reporter sReporter;

    private Report() {
    }

    static void initialize(@NonNull Reporter reporter) {
        sReporter = reporter;
    }

    public static void report(String key) {
        sReporter.report(key);
    }

    public static void report(String key, Map<String, Object> map) {
        sReporter.report(key, map);
    }

    public static void report(String key, Throwable t) {

    }

    static class Empty implements Reporter {

        @Override
        public void report(String key) {

        }

        @Override
        public void report(String key, Map<String, Object> map) {

        }
    }
}
