package common.base;

/**
 * Created by apolunor on 2017/5/14.
 */

public abstract class Singleton<T> {
    private T mInstance;

    protected abstract T create();

    public final T get() {
        if (mInstance == null) {
            synchronized (this) {
                if (mInstance == null) {
                    mInstance = create();
                }
            }
        }
        return mInstance;
    }
}