
package common.base;

import android.os.AsyncTask;
import android.os.Build;
import android.os.Looper;
import android.support.annotation.MainThread;

final class SystemAsyncTaskPatch {
    /**
     * Please call me on main thread and as earlier as possible. The appreciated
     * time is in Application.
     * <p>
     * This method must be invoked on the UI thread.
     */
    @MainThread
    final static void patch() {
        if (Build.VERSION.SDK_INT >= 16) {
            // Build.VERSION_CODES.JELLY_BEAN = 16
            // Doesn't need this hack fix newer than JELLY_BEAN

            return;
        }

        if (Looper.myLooper() != Looper.getMainLooper()) {
            throw new IllegalThreadStateException("This method must be invoked on the UI thread.");
        }

        new AsyncTask<Void, Void, Void>() {
            @Override
            protected Void doInBackground(Void... params) {
                return null;
            }
        };
    }
}
