/*
 * Decompiled with CFR 0.152.
 */
package common.base;

import common.base.ArrayPool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

public class ByteArrayPool
implements ArrayPool<byte[]> {
    private final List<byte[]> mBuffersByLastUse = new LinkedList<byte[]>();
    private final List<byte[]> mBuffersBySize = new ArrayList<byte[]>(64);
    private int mCurrentSize = 0;
    private final int mSizeLimit;
    protected static final Comparator<byte[]> BUF_COMPARATOR = new Comparator<byte[]>(){

        @Override
        public int compare(byte[] lhs, byte[] rhs) {
            return lhs.length - rhs.length;
        }
    };

    public ByteArrayPool(int sizeLimit) {
        this.mSizeLimit = sizeLimit;
    }

    @Override
    public synchronized byte[] acquire(int len) {
        for (int i = 0; i < this.mBuffersBySize.size(); ++i) {
            byte[] buf = this.mBuffersBySize.get(i);
            if (buf.length < len) continue;
            this.mCurrentSize -= buf.length;
            this.mBuffersBySize.remove(i);
            this.mBuffersByLastUse.remove(buf);
            return buf;
        }
        return new byte[len];
    }

    @Override
    public synchronized boolean release(byte[] buf) {
        if (buf == null || buf.length > this.mSizeLimit) {
            return false;
        }
        this.mBuffersByLastUse.add(buf);
        int pos = Collections.binarySearch(this.mBuffersBySize, buf, BUF_COMPARATOR);
        if (pos < 0) {
            pos = -pos - 1;
        }
        this.mBuffersBySize.add(pos, buf);
        this.mCurrentSize += buf.length;
        this.trimToSize(this.mSizeLimit);
        return true;
    }

    @Override
    public synchronized void clearMemory() {
        this.trimToSize(0);
    }

    private void trimToSize(int maxSize) {
        while (this.mCurrentSize > maxSize) {
            byte[] buf = this.mBuffersByLastUse.remove(0);
            this.mBuffersBySize.remove(buf);
            this.mCurrentSize -= buf.length;
        }
    }

    @Override
    public synchronized void trimMemory(int level) {
        if (level >= 40) {
            this.clearMemory();
        } else if (level >= 20) {
            this.trimToSize(this.mSizeLimit / 2);
        }
    }
}

