/*
 * Decompiled with CFR 0.152.
 */
package common.base;

import android.content.ComponentCallbacks;
import android.content.Context;
import android.content.res.Configuration;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import common.base.LogHelper;
import common.base.Report;
import common.base.Service;
import common.base.Singleton;
import common.base.SystemAsyncTaskPatch;

public final class Common
implements Service {
    private Context mContext;
    private boolean mDebug = true;
    private boolean mGlobalCatchError = false;
    private static final Singleton<Common> INSTANCE = new Singleton<Common>(){

        @Override
        protected Common create() {
            return new Common();
        }
    };

    public static final Common getInstance() {
        return INSTANCE.get();
    }

    private Common() {
    }

    @Override
    @MainThread
    public void initialize(@NonNull Context context) {
        this.mContext = context.getApplicationContext();
        this.mContext.registerComponentCallbacks((ComponentCallbacks)this);
        SystemAsyncTaskPatch.patch();
        LogHelper.initialize(new LogHelper.Default(), "", this.mDebug ? 2 : 6);
        Report.initialize(new Report.Empty());
    }

    public void onTrimMemory(int level) {
    }

    public void onConfigurationChanged(Configuration newConfig) {
    }

    public void onLowMemory() {
    }

    public boolean isDebug() {
        return this.mDebug;
    }

    public boolean isGlobalCatchError() {
        return this.mGlobalCatchError;
    }
}

