/*
 * Decompiled with CFR 0.152.
 */
package common.base;

import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.util.Log;
import java.util.Locale;

public final class LogHelper {
    private static Printer sPrinter;
    private static String sTag;
    private static int sLevel;

    private LogHelper() {
    }

    static void initialize(@NonNull Printer printer, @NonNull String tag, @IntRange(from=2L, to=7L) int level) {
        sPrinter = printer;
        sTag = tag;
        sLevel = level;
    }

    public static Printer tag(String tag) {
        return sPrinter.tag(tag);
    }

    public static void d(String message, Object ... args) {
        sPrinter.d(message, args);
    }

    public static void e(String message, Object ... args) {
        sPrinter.e(null, message, args);
    }

    public static void wtf(String message, Object ... args) {
        sPrinter.wtf(message, args);
    }

    public static void i(String message, Object ... args) {
        sPrinter.i(message, args);
    }

    public static void v(String message, Object ... args) {
        sPrinter.v(message, args);
    }

    public static void w(String message, Object ... args) {
        sPrinter.w(message, args);
    }

    static {
        sLevel = 6;
    }

    static class Default
    implements Printer {
        private final ThreadLocal<String> localTag = new ThreadLocal();

        Default() {
        }

        @Override
        public Printer tag(String tag) {
            if (tag != null) {
                this.localTag.set(tag);
            }
            return this;
        }

        @Override
        public void v(String message, Object ... args) {
            this.impl(2, message, args);
        }

        @Override
        public void d(String message, Object ... args) {
            this.impl(3, message, args);
        }

        @Override
        public void i(String message, Object ... args) {
            this.impl(4, message, args);
        }

        @Override
        public void w(String message, Object ... args) {
            this.impl(5, message, args);
        }

        @Override
        public void e(String message, Object ... args) {
            this.impl(6, message, args);
        }

        @Override
        public void wtf(String message, Object ... args) {
            this.impl(7, message, args);
        }

        private void impl(int level, String message, Object ... args) {
            if (level < sLevel) {
                return;
            }
            switch (level) {
                case 6: {
                    Log.e((String)this.getTag(), (String)Default.buildMessage(message, args));
                    break;
                }
                case 7: {
                    Log.wtf((String)this.getTag(), (String)Default.buildMessage(message, args));
                    break;
                }
                case 4: {
                    Log.i((String)this.getTag(), (String)Default.buildMessage(message, args));
                    break;
                }
                case 2: {
                    Log.v((String)this.getTag(), (String)Default.buildMessage(message, args));
                    break;
                }
                case 5: {
                    Log.w((String)this.getTag(), (String)Default.buildMessage(message, args));
                    break;
                }
                default: {
                    Log.d((String)this.getTag(), (String)Default.buildMessage(message, args));
                }
            }
        }

        private String getTag() {
            String tag = this.localTag.get();
            if (tag != null) {
                this.localTag.remove();
                return tag;
            }
            return sTag;
        }

        private static String buildMessage(String message, Object ... args) {
            String msg = args == null ? message : String.format(Locale.US, message, args);
            StackTraceElement[] trace = new Throwable().fillInStackTrace().getStackTrace();
            String caller = "<unknown>";
            for (int i = 2; i < trace.length; ++i) {
                Class<?> clazz = trace[i].getClass();
                if (clazz.equals(Default.class)) continue;
                String callingClass = trace[i].getClassName();
                callingClass = callingClass.substring(callingClass.lastIndexOf(46) + 1);
                callingClass = callingClass.substring(callingClass.lastIndexOf(36) + 1);
                caller = callingClass + "." + trace[i].getMethodName();
                break;
            }
            return String.format(Locale.US, "[%d] %s: %s", Thread.currentThread().getId(), caller, msg);
        }
    }

    public static interface Printer {
        public Printer tag(String var1);

        public void v(String var1, Object ... var2);

        public void d(String var1, Object ... var2);

        public void i(String var1, Object ... var2);

        public void e(String var1, Object ... var2);

        public void wtf(String var1, Object ... var2);

        public void w(String var1, Object ... var2);
    }
}

