/*
 * Decompiled with CFR 0.152.
 */
package com.app55;

public class Environment {
    private String server;
    private int port;
    private boolean ssl;
    private int version;
    public static final Environment DEVELOPMENT = new Environment("dev.app55.com", 80, false, 1);
    public static final Environment SANDBOX = new Environment("sandbox.app55.com", 443, true, 1);
    public static final Environment PRODUCTION = new Environment("api.app55.com", 443, true, 1);

    public Environment(String server, int port, boolean ssl, int version) {
        this.server = server;
        this.port = port;
        this.ssl = ssl;
        this.version = version;
    }

    public String getBaseUrl() {
        return this.getScheme() + "://" + this.getHost() + "/v" + this.version;
    }

    private String getScheme() {
        return this.ssl ? "https" : "http";
    }

    private String getHost() {
        if (this.port == 443 && this.ssl) {
            return this.server;
        }
        if (this.port == 80 && !this.ssl) {
            return this.server;
        }
        return this.server + ":" + this.port;
    }
}

