/*
 * Decompiled with CFR 0.152.
 */
package com.app55.converter;

import com.app55.converter.IConverter;
import com.app55.converter.PrimitiveConverter;
import java.util.ArrayList;
import java.util.List;

public class Converter
implements IConverter {
    private List<IConverter> converters = new ArrayList<IConverter>();
    private static Converter instance;

    private Converter() {
        this.register(new PrimitiveConverter());
    }

    public static Converter getInstance() {
        if (instance == null) {
            instance = new Converter();
        }
        return instance;
    }

    private void register(IConverter converter) {
        if (converter == this) {
            throw new IllegalArgumentException();
        }
        this.converters.add(converter);
    }

    @Override
    public boolean canConvert(Object o) {
        for (IConverter converter : this.converters) {
            if (!converter.canConvert(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String convert(Object o) {
        if (o == null) {
            return null;
        }
        for (IConverter converter : this.converters) {
            if (!converter.canConvert(o)) continue;
            return converter.convert(o);
        }
        return null;
    }

    @Override
    public <T> T convert(String s, Class<T> type) {
        for (IConverter converter : this.converters) {
            if (!converter.canConvert(s)) continue;
            return converter.convert(s, type);
        }
        return null;
    }
}

