/*
 * Decompiled with CFR 0.152.
 */
package com.app55.error;

import com.app55.error.AuthenticationException;
import com.app55.error.CardException;
import com.app55.error.RequestException;
import com.app55.error.ResourceException;
import com.app55.error.ServerException;
import com.app55.error.ValidationException;
import java.util.Map;

public class ApiException
extends RuntimeException {
    private String message;
    private Long code;
    private Map<String, Object> body;
    private static final long serialVersionUID = 838615854773225757L;

    ApiException(String message, Long code, Map<String, Object> body) {
        this.message = message;
        this.code = code;
        this.body = body;
    }

    @Override
    public String toString() {
        return this.message;
    }

    public static ApiException createException(Map<String, Object> error) {
        String type = (String)error.get("type");
        String message = (String)error.get("message");
        Integer codeInt = (Integer)error.get("code");
        Long code = codeInt != null ? Long.valueOf(codeInt.longValue()) : null;
        Map body = (Map)error.get("body");
        if ("request-error".equals(type)) {
            return new RequestException(message, code, body);
        }
        if ("resource-error".equals(type)) {
            return new ResourceException(message, code, body);
        }
        if ("authentication-error".equals(type)) {
            return new AuthenticationException(message, code, body);
        }
        if ("server-error".equals(type)) {
            return new ServerException(message, code, body);
        }
        if ("validation-error".equals(type)) {
            return new ValidationException(message, code, body);
        }
        if ("card-error".equals(type)) {
            return new CardException(message, code, body);
        }
        return new ApiException(message, code, body);
    }

    public static ApiException createException(String message, Long code) {
        return new ApiException(message, code, null);
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public Long getCode() {
        return this.code;
    }

    public Map<String, Object> getBody() {
        return this.body;
    }
}

