/*
 * Decompiled with CFR 0.152.
 */
package com.app55.message;

import com.app55.Gateway;
import com.app55.converter.Converter;
import com.app55.util.EncodeUtil;
import com.app55.util.ReflectionUtil;
import com.googlecode.openbeans.PropertyDescriptor;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;

public abstract class Message {
    protected Map<String, String> additionalFields = new HashMap<String, String>();
    private Gateway gateway;

    @JsonIgnore
    public Gateway getGateway() {
        return this.gateway;
    }

    public void setGateway(Gateway gateway) {
        this.gateway = gateway;
    }

    @JsonProperty(value="sig")
    public abstract String getSignature();

    @JsonProperty(value="ts")
    public abstract String getTimestamp();

    @JsonIgnore
    public String getFormData() {
        return this.toFormData(true, null);
    }

    protected String toSignature() {
        return this.toSignature(false);
    }

    protected String toSignature(boolean includeApiKey) {
        HashMap<String, Boolean> exclude = new HashMap<String, Boolean>();
        exclude.put("sig", true);
        String formData = this.toFormData(includeApiKey, exclude);
        byte[] digest = EncodeUtil.sha1(this.gateway.getApiSecret() + formData);
        return EncodeUtil.base64(digest);
    }

    public String toFormData(boolean includeApiKey, Map<String, Boolean> exclude) {
        try {
            String formData = "";
            Map<String, String> description = this.describe(this, null, exclude);
            if (includeApiKey) {
                description.put("api_key", this.gateway.getApiKey());
                if (exclude == null || !exclude.containsKey("sig")) {
                    description.remove("sig");
                    description.put("sig", this.toSignature(true));
                }
            }
            for (Map.Entry<String, String> entry : this.additionalFields.entrySet()) {
                description.put(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : description.entrySet()) {
                formData = formData + "&" + entry.getKey() + "=" + URLEncoder.encode(entry.getValue(), "UTF-8");
            }
            if (formData.length() > 0) {
                formData = formData.substring(1);
            }
            formData = formData.replace("+", "%20");
            formData = formData.replace("+", "%20");
            return formData;
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    private Map<String, String> describe(Object o) {
        return this.describe(o, null, null);
    }

    private Map<String, String> describe(Object o, String prefix) {
        return this.describe(o, prefix, null);
    }

    private Map<String, String> describe(Object o, String prefix, Map<String, Boolean> exclude) {
        if (o == null) {
            return new HashMap<String, String>();
        }
        prefix = prefix == null ? "" : prefix + ".";
        TreeMap<String, String> description = new TreeMap<String, String>();
        Map<String, PropertyDescriptor> properties = ReflectionUtil.getAllProperties(o);
        for (Map.Entry<String, PropertyDescriptor> property : properties.entrySet()) {
            Method m = property.getValue().getReadMethod();
            if (exclude != null && exclude.containsKey(property.getKey())) continue;
            Object value = null;
            try {
                value = m.invoke(o, new Object[0]);
            }
            catch (InvocationTargetException e) {
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
            if (value == null) continue;
            if (Converter.getInstance().canConvert(value)) {
                description.put(prefix + property.getKey(), Converter.getInstance().convert(value));
                continue;
            }
            if (value instanceof Collection) {
                int i = 0;
                for (Object obj : (Collection)value) {
                    for (Map.Entry<String, String> entry : this.describe(obj, prefix + property.getKey() + '.' + i).entrySet()) {
                        description.put(entry.getKey(), entry.getValue());
                    }
                    ++i;
                }
                continue;
            }
            for (Map.Entry<String, String> entry : this.describe(value, prefix + property.getKey()).entrySet()) {
                description.put(entry.getKey(), entry.getValue());
            }
        }
        return description;
    }
}

