/*
 * Decompiled with CFR 0.152.
 */
package com.app55.message;

import com.app55.error.ApiException;
import com.app55.error.InvalidSignatureException;
import com.app55.error.RequestException;
import com.app55.message.Message;
import com.app55.message.Response;
import com.app55.message.ResponseListener;
import com.app55.transport.HttpListener;
import com.app55.transport.HttpResponse;
import com.app55.util.EncodeUtil;
import com.app55.util.JsonUtil;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;

public abstract class Request<T extends Response>
extends Message {
    private Class<T> responseClass;

    Request(Class<T> responseClass) {
        this.responseClass = responseClass;
    }

    @JsonIgnore
    public abstract String getHttpEndpoint();

    @JsonIgnore
    public String getHttpMethod() {
        return "GET";
    }

    @Override
    @JsonIgnore
    @JsonProperty(value="sig")
    public String getSignature() {
        return this.toSignature(true);
    }

    @Override
    @JsonProperty(value="ts")
    public String getTimestamp() {
        return new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
    }

    public T send() throws ApiException {
        try {
            String qs = this.fetchQueryString();
            byte[] data = this.fetchData(qs);
            String url = this.fetchUrl(qs);
            String authString = this.fetchAuthString();
            HttpResponse response = this.getGateway().getHttpAdapter().onSendRequest(data, url, this.getHttpMethod(), authString);
            return this.processRequest(response);
        }
        catch (ApiException a) {
            throw a;
        }
        catch (Exception e) {
            throw ApiException.createException(e.getMessage(), -1L);
        }
    }

    public T send(Map<String, String> headers) throws ApiException {
        try {
            String qs = this.fetchQueryString();
            byte[] data = this.fetchData(qs);
            String url = this.fetchUrl("");
            String authString = this.fetchAuthString();
            HttpResponse response = this.getGateway().getHttpAdapter().onSendRequest(data, url, this.getHttpMethod(), authString, headers);
            return this.processRequest(response);
        }
        catch (ApiException a) {
            throw a;
        }
        catch (Exception e) {
            throw ApiException.createException(e.getMessage(), -1L);
        }
    }

    public void send(final ResponseListener<T> responseListener) {
        try {
            String qs = this.fetchQueryString();
            byte[] data = this.fetchData(qs);
            String url = this.fetchUrl(qs);
            String authString = this.fetchAuthString();
            this.getGateway().getHttpAdapter().onSendRequest(data, url, this.getHttpMethod(), authString, new HttpListener(){

                @Override
                public void onResponse(HttpResponse response) {
                    Response r = Request.this.processRequest(response);
                    responseListener.onResponse(r);
                }

                @Override
                public void onError(Exception e) {
                    responseListener.onError(Request.this.processException(e));
                }
            });
        }
        catch (Exception e) {
            responseListener.onError(this.processException(e));
        }
    }

    private T processRequest(HttpResponse response) {
        if (response.getStatusCode() != 200) {
            throw new RequestException("Http Error " + response.getStatusCode(), Long.valueOf(response.getStatusCode()), null);
        }
        Map<String, Object> ht = JsonUtil.map(response.getContent());
        if (ht.containsKey("error")) {
            throw ApiException.createException((Map)ht.get("error"));
        }
        Response r = (Response)JsonUtil.object(response.getContent(), this.responseClass);
        r.populate(ht);
        r.setGateway(this.getGateway());
        if (!r.isValidSignature()) {
            throw new InvalidSignatureException();
        }
        return (T)r;
    }

    private ApiException processException(Exception e) {
        ApiException apiEx = null;
        apiEx = e instanceof ApiException ? (ApiException)e : ApiException.createException(e.getMessage(), -1L);
        return apiEx;
    }

    private String fetchAuthString() {
        String authString = EncodeUtil.createBasicAuthString(this.getGateway().getApiKey(), this.getGateway().getApiSecret());
        return authString;
    }

    private String fetchUrl(String qs) {
        return this.isBodySent() ? this.getHttpEndpoint() : this.getHttpEndpoint() + "?" + qs;
    }

    private byte[] fetchData(String qs) throws UnsupportedEncodingException {
        return this.isBodySent() ? qs.getBytes("UTF-8") : null;
    }

    private String fetchQueryString() {
        HashMap<String, Boolean> exclude = new HashMap<String, Boolean>();
        exclude.put("sig", true);
        exclude.put("ts", true);
        exclude.put("httpEndpoint", true);
        exclude.put("redirectUrl", true);
        String qs = this.toFormData(false, exclude);
        return qs;
    }

    private boolean isBodySent() {
        return !"GET".equals(this.getHttpMethod()) && !"DELETE".equals(this.getHttpMethod());
    }
}

