/*
 * Decompiled with CFR 0.152.
 */
package com.app55.message;

import com.app55.Gateway;
import com.app55.message.Message;
import com.app55.util.ReflectionUtil;
import com.googlecode.openbeans.PropertyDescriptor;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;

public class Response
extends Message {
    private String signature;
    private String timestamp;

    protected Response() {
    }

    protected Response(Gateway gateway, Map<String, Object> ht) {
        this.setGateway(gateway);
        this.populate(ht);
    }

    @Override
    @JsonProperty(value="sig")
    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    @Override
    @JsonProperty(value="ts")
    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    @JsonIgnore
    public boolean isValidSignature() {
        String expectedSig = this.getExpectedSignature();
        return expectedSig.equals(this.signature);
    }

    @JsonIgnore
    public String getExpectedSignature() {
        return this.toSignature();
    }

    private void populateAdditional(Map<String, Object> hashtable, String prefix) {
        TreeMap<String, Object> ht = new TreeMap<String, Object>(hashtable);
        for (Map.Entry entry : ht.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value == null) continue;
            if (value instanceof Map) {
                this.populateAdditional((Map)value, prefix + key + ".");
                continue;
            }
            if (value instanceof List) {
                int i = 0;
                for (Object arrayItem : (List)value) {
                    if (arrayItem instanceof Map) {
                        this.populateAdditional((Map)arrayItem, prefix + key + "." + i++ + ".");
                        continue;
                    }
                    this.additionalFields.put(prefix + key + "." + i++, arrayItem.toString());
                }
                continue;
            }
            this.additionalFields.put(prefix + key, value.toString());
        }
    }

    public void populate(Map<String, Object> hashtable) {
        this.populate(hashtable, null);
    }

    private void populate(Map<String, Object> hashtable, Object o) {
        this.populate(hashtable, o, "");
    }

    private void populate(Map<String, Object> hashtable, Object o, String prefix) {
        if (o == null) {
            o = this;
        }
        Map<String, PropertyDescriptor> properties = ReflectionUtil.getAllProperties(o);
        for (Map.Entry<String, Object> entry : hashtable.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value != null && properties.containsKey(key) || value == null) continue;
            if (value instanceof Map) {
                this.populateAdditional((Map)value, prefix + key + ".");
                continue;
            }
            if (value instanceof List) {
                int i = 0;
                for (Object arrayItem : (List)value) {
                    if (arrayItem instanceof Map) {
                        this.populateAdditional((Map)arrayItem, prefix + key + "." + i++ + ".");
                        continue;
                    }
                    this.additionalFields.put(prefix + key + "." + i++, arrayItem.toString());
                }
                continue;
            }
            this.additionalFields.put(prefix + key, value.toString());
        }
    }
}

