/*
 * Decompiled with CFR 0.152.
 */
package com.app55.message;

import com.app55.domain.Card;
import com.app55.domain.Transaction;
import com.app55.domain.User;
import com.app55.message.Request;
import com.app55.message.TransactionCreateResponse;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;

public final class TransactionCreateRequest
extends Request<TransactionCreateResponse> {
    private User user;
    private Card card;
    private Transaction transaction;
    private String ipAddress;
    private boolean threeds;

    public TransactionCreateRequest() {
        super(TransactionCreateResponse.class);
    }

    public TransactionCreateRequest(User user, Card card, Transaction transaction) {
        this(user, card, transaction, false);
    }

    public TransactionCreateRequest(User user, Card card, Transaction transaction, boolean threeds) {
        this();
        this.user = user;
        this.card = card;
        this.transaction = transaction;
        this.threeds = threeds;
    }

    public TransactionCreateRequest(User user, Card card, Transaction transaction, String ipAddress) {
        this(user, card, transaction);
        this.ipAddress = ipAddress;
    }

    public TransactionCreateRequest(Card card, Transaction transaction) {
        this(null, card, transaction);
    }

    @Override
    @JsonIgnore
    public String getHttpEndpoint() {
        return this.getGateway().getEnvironment().getBaseUrl() + "/transaction";
    }

    @Override
    @JsonIgnore
    public String getHttpMethod() {
        return "POST";
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Card getCard() {
        return this.card;
    }

    public void setCard(Card card) {
        this.card = card;
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public void setTransaction(Transaction transaction) {
        this.transaction = transaction;
    }

    @JsonProperty(value="ip_address")
    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    @JsonProperty(value="threeds")
    public boolean isThreeDSecure() {
        return this.threeds;
    }

    public void setThreeDSecure(boolean threeds) {
        this.threeds = threeds;
    }
}

