/*
 * Decompiled with CFR 0.152.
 */
package com.app55.util;

import com.googlecode.openbeans.IntrospectionException;
import com.googlecode.openbeans.Introspector;
import com.googlecode.openbeans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;

public final class ReflectionUtil {
    public static Map<String, PropertyDescriptor> getAllProperties(Object o) {
        return ReflectionUtil.getAllProperties(o, null);
    }

    private static Map<String, PropertyDescriptor> getAllProperties(Object o, Map<String, Boolean> exclude) {
        try {
            PropertyDescriptor[] propertyDescriptors = Introspector.getBeanInfo(o.getClass()).getPropertyDescriptors();
            HashMap<String, PropertyDescriptor> properties = new HashMap<String, PropertyDescriptor>();
            for (PropertyDescriptor p : propertyDescriptors) {
                if ("class".equals(p.getName()) || p.getReadMethod().getAnnotation(JsonIgnore.class) != null) continue;
                String name = p.getName();
                JsonProperty altName = p.getReadMethod().getAnnotation(JsonProperty.class);
                if (altName != null && altName.value().length() > 0) {
                    name = altName.value();
                }
                if (exclude != null && exclude.containsKey(name) && exclude.get(name).booleanValue()) continue;
                properties.put(name, p);
            }
            return properties;
        }
        catch (IntrospectionException e) {
            return null;
        }
    }

    public static Object invokeMethod(String name, Object object, Class<?>[] parameterTypes, Object[] params) {
        try {
            Method m = ReflectionUtil.getMethod(name, object.getClass(), parameterTypes);
            m.setAccessible(true);
            return m.invoke(object, params);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object getMember(String name, Object object) {
        try {
            Field f = ReflectionUtil.getField(name, object.getClass());
            if (f == null) {
                return null;
            }
            f.setAccessible(true);
            return f.get(object);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Field getField(String fieldName, Class clazz) throws NoSuchFieldException {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            Class superClass = clazz.getSuperclass();
            if (superClass == null) {
                throw e;
            }
            return ReflectionUtil.getField(fieldName, superClass);
        }
    }

    private static Method getMethod(String methodName, Class clazz, Class<?>[] parameterTypes) throws NoSuchMethodException {
        try {
            return clazz.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            Class superClass = clazz.getSuperclass();
            if (superClass == null) {
                throw e;
            }
            return ReflectionUtil.getMethod(methodName, superClass, parameterTypes);
        }
    }
}

