/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.openbeans;

import com.googlecode.openbeans.ArrayPersistenceDelegate;
import com.googlecode.openbeans.AwtChoicePersistenceDelegate;
import com.googlecode.openbeans.AwtColorPersistenceDelegate;
import com.googlecode.openbeans.AwtComponentPersistenceDelegate;
import com.googlecode.openbeans.AwtContainerPersistenceDelegate;
import com.googlecode.openbeans.AwtCursorPersistenceDelegate;
import com.googlecode.openbeans.AwtDimensionPersistenceDelegate;
import com.googlecode.openbeans.AwtFontPersistenceDelegate;
import com.googlecode.openbeans.AwtFontTextAttributePersistenceDelegate;
import com.googlecode.openbeans.AwtInsetsPersistenceDelegate;
import com.googlecode.openbeans.AwtListPersistenceDelegate;
import com.googlecode.openbeans.AwtMenuBarPersistenceDelegate;
import com.googlecode.openbeans.AwtMenuPersistenceDelegate;
import com.googlecode.openbeans.AwtMenuShortcutPersistenceDelegate;
import com.googlecode.openbeans.AwtPointPersistenceDelegate;
import com.googlecode.openbeans.AwtRectanglePersistenceDelegate;
import com.googlecode.openbeans.AwtScrollPanePersistenceDelegate;
import com.googlecode.openbeans.AwtSystemColorPersistenceDelegate;
import com.googlecode.openbeans.BeanInfo;
import com.googlecode.openbeans.ClassPersistenceDelegate;
import com.googlecode.openbeans.DefaultPersistenceDelegate;
import com.googlecode.openbeans.ExceptionListener;
import com.googlecode.openbeans.Expression;
import com.googlecode.openbeans.FieldPersistenceDelegate;
import com.googlecode.openbeans.Introspector;
import com.googlecode.openbeans.MethodPersistenceDelegate;
import com.googlecode.openbeans.NullPersistenceDelegate;
import com.googlecode.openbeans.PersistenceDelegate;
import com.googlecode.openbeans.PrimitiveWrapperPersistenceDelegate;
import com.googlecode.openbeans.ProxyPersistenceDelegate;
import com.googlecode.openbeans.Statement;
import com.googlecode.openbeans.StringPersistenceDelegate;
import com.googlecode.openbeans.SwingBoxPersistenceDelegate;
import com.googlecode.openbeans.SwingDefaultComboBoxModelPersistenceDelegate;
import com.googlecode.openbeans.SwingJFramePersistenceDelegate;
import com.googlecode.openbeans.SwingJTabbedPanePersistenceDelegate;
import com.googlecode.openbeans.SwingToolTipManagerPersistenceDelegate;
import com.googlecode.openbeans.UtilCollectionPersistenceDelegate;
import com.googlecode.openbeans.UtilCollectionsPersistenceDelegate;
import com.googlecode.openbeans.UtilDatePersistenceDelegate;
import com.googlecode.openbeans.UtilListPersistenceDelegate;
import com.googlecode.openbeans.UtilMapPersistenceDelegate;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuShortcut;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.SystemColor;
import java.awt.font.TextAttribute;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.ToolTipManager;

public class Encoder {
    private static final Hashtable<Class<?>, PersistenceDelegate> delegates = new Hashtable();
    private static final DefaultPersistenceDelegate defaultPD = new DefaultPersistenceDelegate();
    private static final UtilCollectionsPersistenceDelegate utilCollectionsPD = new UtilCollectionsPersistenceDelegate();
    private static final ArrayPersistenceDelegate arrayPD = new ArrayPersistenceDelegate();
    private static final ProxyPersistenceDelegate proxyPD = new ProxyPersistenceDelegate();
    private static final NullPersistenceDelegate nullPD = new NullPersistenceDelegate();
    private static final ExceptionListener defaultExListener = new DefaultExceptionListener();
    private ExceptionListener listener = defaultExListener;
    private IdentityHashMap<Object, Object> oldNewMap = new IdentityHashMap();

    void clear() {
        this.oldNewMap.clear();
    }

    public Object get(Object old) {
        if (old == null || old.getClass() == String.class) {
            return old;
        }
        return this.oldNewMap.get(old);
    }

    public ExceptionListener getExceptionListener() {
        return this.listener;
    }

    public PersistenceDelegate getPersistenceDelegate(Class<?> type) {
        if (type == null) {
            return nullPD;
        }
        PersistenceDelegate registeredPD = delegates.get(type);
        if (registeredPD != null) {
            return registeredPD;
        }
        if (type.getName().startsWith(UtilCollectionsPersistenceDelegate.CLASS_PREFIX)) {
            return utilCollectionsPD;
        }
        if (type.isArray()) {
            return arrayPD;
        }
        if (Proxy.isProxyClass(type)) {
            return proxyPD;
        }
        try {
            PersistenceDelegate pd;
            BeanInfo beanInfo = Introspector.getBeanInfo(type);
            if (beanInfo != null && (pd = (PersistenceDelegate)beanInfo.getBeanDescriptor().getValue("persistenceDelegate")) != null) {
                return pd;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultPD;
    }

    public Object remove(Object old) {
        return this.oldNewMap.remove(old);
    }

    public void setExceptionListener(ExceptionListener listener) {
        this.listener = listener == null ? defaultExListener : listener;
    }

    public void setPersistenceDelegate(Class<?> type, PersistenceDelegate delegate) {
        if (type == null || delegate == null) {
            throw new NullPointerException();
        }
        delegates.put(type, delegate);
    }

    Object expressionValue(Expression exp) {
        try {
            return exp == null ? null : exp.getValue();
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
        catch (Exception e) {
            this.listener.exceptionThrown(new Exception("failed to excute expression: " + exp, e));
            return null;
        }
    }

    private Statement createNewStatement(Statement oldStat) {
        Object newTarget = this.createNewObject(oldStat.getTarget());
        Object[] oldArgs = oldStat.getArguments();
        Object[] newArgs = new Object[oldArgs.length];
        for (int index = 0; index < oldArgs.length; ++index) {
            newArgs[index] = this.createNewObject(oldArgs[index]);
        }
        if (oldStat.getClass() == Expression.class) {
            return new Expression(newTarget, oldStat.getMethodName(), newArgs);
        }
        return new Statement(newTarget, oldStat.getMethodName(), newArgs);
    }

    private Object createNewObject(Object old) {
        Object nu = this.get(old);
        if (nu == null) {
            this.writeObject(old);
            nu = this.get(old);
        }
        return nu;
    }

    public void writeExpression(Expression oldExp) {
        if (oldExp == null) {
            throw new NullPointerException();
        }
        try {
            Object oldValue = this.expressionValue(oldExp);
            if (oldValue == null || this.get(oldValue) != null) {
                return;
            }
            Expression newExp = (Expression)this.createNewStatement(oldExp);
            try {
                this.oldNewMap.put(oldValue, newExp.getValue());
            }
            catch (IndexOutOfBoundsException e) {
                // empty catch block
            }
            this.writeObject(oldValue);
        }
        catch (Exception e) {
            this.listener.exceptionThrown(new Exception("failed to write expression: " + oldExp, e));
        }
    }

    protected void writeObject(Object o) {
        if (o == null) {
            return;
        }
        this.getPersistenceDelegate(o.getClass()).writeObject(o, this);
    }

    public void writeStatement(Statement oldStat) {
        if (oldStat == null) {
            throw new NullPointerException();
        }
        Statement newStat = this.createNewStatement(oldStat);
        try {
            newStat.execute();
        }
        catch (Exception e) {
            this.listener.exceptionThrown(new Exception("failed to write statement: " + oldStat, e));
        }
    }

    static {
        PrimitiveWrapperPersistenceDelegate ppd = new PrimitiveWrapperPersistenceDelegate();
        delegates.put(Boolean.class, ppd);
        delegates.put(Byte.class, ppd);
        delegates.put(Character.class, ppd);
        delegates.put(Double.class, ppd);
        delegates.put(Float.class, ppd);
        delegates.put(Integer.class, ppd);
        delegates.put(Long.class, ppd);
        delegates.put(Short.class, ppd);
        delegates.put(Class.class, new ClassPersistenceDelegate());
        delegates.put(Field.class, new FieldPersistenceDelegate());
        delegates.put(Method.class, new MethodPersistenceDelegate());
        delegates.put(String.class, new StringPersistenceDelegate());
        delegates.put(Proxy.class, new ProxyPersistenceDelegate());
        delegates.put(Choice.class, new AwtChoicePersistenceDelegate());
        delegates.put(Color.class, new AwtColorPersistenceDelegate());
        delegates.put(Container.class, new AwtContainerPersistenceDelegate());
        delegates.put(Component.class, new AwtComponentPersistenceDelegate());
        delegates.put(Cursor.class, new AwtCursorPersistenceDelegate());
        delegates.put(Dimension.class, new AwtDimensionPersistenceDelegate());
        delegates.put(Font.class, new AwtFontPersistenceDelegate());
        delegates.put(Insets.class, new AwtInsetsPersistenceDelegate());
        delegates.put(List.class, new AwtListPersistenceDelegate());
        delegates.put(Menu.class, new AwtMenuPersistenceDelegate());
        delegates.put(MenuBar.class, new AwtMenuBarPersistenceDelegate());
        delegates.put(MenuShortcut.class, new AwtMenuShortcutPersistenceDelegate());
        delegates.put(Point.class, new AwtPointPersistenceDelegate());
        delegates.put(Rectangle.class, new AwtRectanglePersistenceDelegate());
        delegates.put(SystemColor.class, new AwtSystemColorPersistenceDelegate());
        delegates.put(TextAttribute.class, new AwtFontTextAttributePersistenceDelegate());
        delegates.put(Box.class, new SwingBoxPersistenceDelegate());
        delegates.put(JFrame.class, new SwingJFramePersistenceDelegate());
        delegates.put(JTabbedPane.class, new SwingJTabbedPanePersistenceDelegate());
        delegates.put(DefaultComboBoxModel.class, new SwingDefaultComboBoxModelPersistenceDelegate());
        delegates.put(ToolTipManager.class, new SwingToolTipManagerPersistenceDelegate());
        delegates.put(ScrollPane.class, new AwtScrollPanePersistenceDelegate());
        delegates.put(Date.class, new UtilDatePersistenceDelegate());
        DefaultPersistenceDelegate pd = new UtilListPersistenceDelegate();
        delegates.put(java.util.List.class, pd);
        delegates.put(AbstractList.class, pd);
        pd = new UtilCollectionPersistenceDelegate();
        delegates.put(Collection.class, pd);
        delegates.put(AbstractCollection.class, pd);
        pd = new UtilMapPersistenceDelegate();
        delegates.put(Map.class, pd);
        delegates.put(AbstractMap.class, pd);
        delegates.put(Hashtable.class, pd);
    }

    private static class DefaultExceptionListener
    implements ExceptionListener {
        private DefaultExceptionListener() {
        }

        @Override
        public void exceptionThrown(Exception exception) {
            System.err.println("Exception during encoding:" + exception);
            System.err.println("Continue...");
        }
    }
}

