/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.openbeans;

import com.googlecode.openbeans.PropertyEditor;
import java.util.HashMap;
import java.util.Map;

public class PropertyEditorManager {
    private static String[] path = new String[]{"org.apache.harmony.beans.editors"};
    private static final Map<Class<?>, Class<?>> registeredEditors = new HashMap();

    public static void registerEditor(Class<?> targetType, Class<?> editorClass) {
        if (targetType == null) {
            throw new NullPointerException();
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPropertiesAccess();
        }
        if (editorClass != null) {
            registeredEditors.put(targetType, editorClass);
        } else {
            registeredEditors.remove(targetType);
        }
    }

    private static PropertyEditor loadEditor(Class<?> targetType, String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        ClassLoader loader = targetType.getClassLoader();
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        try {
            return (PropertyEditor)loader.loadClass(className).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return (PropertyEditor)Thread.currentThread().getContextClassLoader().loadClass(className).newInstance();
        }
    }

    public static synchronized PropertyEditor findEditor(Class<?> targetType) {
        if (targetType == null) {
            throw new NullPointerException();
        }
        Class<?> editorClass = registeredEditors.get(targetType);
        if (editorClass != null) {
            try {
                return (PropertyEditor)editorClass.newInstance();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        String editorClassName = targetType.getName() + "Editor";
        try {
            return PropertyEditorManager.loadEditor(targetType, editorClassName);
        }
        catch (Exception exception) {
            String shortEditorClassName = targetType.isPrimitive() ? editorClassName.substring(0, 1).toUpperCase() + editorClassName.substring(1) : editorClassName.substring(editorClassName.lastIndexOf(46) + 1);
            for (String element : path) {
                if (element == null) continue;
                try {
                    return PropertyEditorManager.loadEditor(targetType, element + '.' + shortEditorClassName);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setEditorSearchPath(String[] apath) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPropertiesAccess();
        }
        Class<PropertyEditorManager> clazz = PropertyEditorManager.class;
        synchronized (PropertyEditorManager.class) {
            path = apath == null ? new String[]{} : apath;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static synchronized String[] getEditorSearchPath() {
        return (String[])path.clone();
    }
}

