/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.openbeans;

import com.googlecode.openbeans.Encoder;
import com.googlecode.openbeans.Expression;
import com.googlecode.openbeans.PersistenceDelegate;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.harmony.beans.BeansUtils;

class UtilCollectionsPersistenceDelegate
extends PersistenceDelegate {
    static String CLASS_PREFIX = "java.util.Collections$";
    private static final String COLLECTIONS_TYPE = "type";
    private static final String MAP_KEY_TYPE = "keyType";
    private static final String MAP_VALUE_TYPE = "valueType";

    UtilCollectionsPersistenceDelegate() {
    }

    @Override
    protected boolean mutatesTo(Object o1, Object o2) {
        if (BeansUtils.declaredEquals(o1.getClass())) {
            return o1.equals(o2);
        }
        if (o1 instanceof Collection) {
            Collection c1 = (Collection)o1;
            Collection c2 = (Collection)o2;
            return c1.size() == c2.size() && c1.containsAll(c2);
        }
        if (o1 instanceof Map) {
            Map m1 = (Map)o1;
            Map m2 = (Map)o2;
            return m1.size() == m2.size() && m1.entrySet().containsAll(m2.entrySet());
        }
        return super.mutatesTo(o1, o2);
    }

    @Override
    protected Expression instantiate(Object oldInstance, Encoder enc) {
        String className = oldInstance.getClass().getName();
        if (className.endsWith("UnmodifiableCollection")) {
            return new Expression(oldInstance, Collections.class, "unmodifiableCollection", new Object[]{new ArrayList((Collection)oldInstance)});
        }
        if (className.endsWith("UnmodifiableList")) {
            return new Expression(oldInstance, Collections.class, "unmodifiableList", new Object[]{new LinkedList((Collection)oldInstance)});
        }
        if (className.endsWith("UnmodifiableRandomAccessList")) {
            return new Expression(oldInstance, Collections.class, "unmodifiableList", new Object[]{new ArrayList((Collection)oldInstance)});
        }
        if (className.endsWith("UnmodifiableSet")) {
            return new Expression(oldInstance, Collections.class, "unmodifiableSet", new Object[]{new HashSet((Set)oldInstance)});
        }
        if (className.endsWith("UnmodifiableSortedSet")) {
            return new Expression(oldInstance, Collections.class, "unmodifiableSortedSet", new Object[]{new TreeSet((SortedSet)oldInstance)});
        }
        if (className.endsWith("UnmodifiableMap")) {
            return new Expression(oldInstance, Collections.class, "unmodifiableMap", new Object[]{new HashMap((Map)oldInstance)});
        }
        if (className.endsWith("UnmodifiableSortedMap")) {
            return new Expression(oldInstance, Collections.class, "unmodifiableSortedMap", new Object[]{new TreeMap((Map)oldInstance)});
        }
        if (className.endsWith("SynchronizedCollection")) {
            return new Expression(oldInstance, Collections.class, "synchronizedCollection", new Object[]{new ArrayList((Collection)oldInstance)});
        }
        if (className.endsWith("SynchronizedList")) {
            return new Expression(oldInstance, Collections.class, "synchronizedList", new Object[]{new LinkedList((List)oldInstance)});
        }
        if (className.endsWith("SynchronizedRandomAccessList")) {
            return new Expression(oldInstance, Collections.class, "synchronizedList", new Object[]{new ArrayList((List)oldInstance)});
        }
        if (className.endsWith("SynchronizedSet")) {
            return new Expression(oldInstance, Collections.class, "synchronizedSet", new Object[]{new HashSet((Set)oldInstance)});
        }
        if (className.endsWith("SynchronizedSortedSet")) {
            return new Expression(oldInstance, Collections.class, "synchronizedSortedSet", new Object[]{new TreeSet((SortedSet)oldInstance)});
        }
        if (className.endsWith("SynchronizedMap")) {
            return new Expression(oldInstance, Collections.class, "synchronizedMap", new Object[]{new HashMap((Map)oldInstance)});
        }
        if (className.endsWith("SynchronizedSortedMap")) {
            return new Expression(oldInstance, Collections.class, "synchronizedSortedMap", new Object[]{new TreeMap((SortedMap)oldInstance)});
        }
        if (className.endsWith("CheckedCollection")) {
            return new Expression(oldInstance, Collections.class, "checkedCollection", new Object[]{new ArrayList((Collection)oldInstance), UtilCollectionsPersistenceDelegate.valueOfField(oldInstance, COLLECTIONS_TYPE)});
        }
        if (className.endsWith("CheckedList")) {
            return new Expression(oldInstance, Collections.class, "checkedList", new Object[]{new LinkedList((Collection)oldInstance), UtilCollectionsPersistenceDelegate.valueOfField(oldInstance, COLLECTIONS_TYPE)});
        }
        if (className.endsWith("CheckedRandomAccessList")) {
            return new Expression(oldInstance, Collections.class, "checkedList", new Object[]{new ArrayList((Collection)oldInstance), UtilCollectionsPersistenceDelegate.valueOfField(oldInstance, COLLECTIONS_TYPE)});
        }
        if (className.endsWith("CheckedSet")) {
            return new Expression(oldInstance, Collections.class, "checkedSet", new Object[]{new HashSet((Set)oldInstance), UtilCollectionsPersistenceDelegate.valueOfField(oldInstance, COLLECTIONS_TYPE)});
        }
        if (className.endsWith("CheckedSortedSet")) {
            return new Expression(oldInstance, Collections.class, "checkedSortedSet", new Object[]{new TreeSet((Set)oldInstance), UtilCollectionsPersistenceDelegate.valueOfField(oldInstance, COLLECTIONS_TYPE)});
        }
        if (className.endsWith("CheckedMap")) {
            return new Expression(oldInstance, Collections.class, "checkedMap", new Object[]{new HashMap((Map)oldInstance), UtilCollectionsPersistenceDelegate.valueOfField(oldInstance, MAP_KEY_TYPE), UtilCollectionsPersistenceDelegate.valueOfField(oldInstance, MAP_VALUE_TYPE)});
        }
        if (className.endsWith("CheckedSortedMap")) {
            return new Expression(oldInstance, Collections.class, "checkedSortedMap", new Object[]{new TreeMap((Map)oldInstance), UtilCollectionsPersistenceDelegate.valueOfField(oldInstance, MAP_KEY_TYPE), UtilCollectionsPersistenceDelegate.valueOfField(oldInstance, MAP_VALUE_TYPE)});
        }
        return null;
    }

    private static Object valueOfField(Object obj, String fieldName) {
        AccessibleObject field = null;
        block2: for (Class<?> clazz = obj.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            for (Field declaredField : clazz.getDeclaredFields()) {
                if (!fieldName.equals(declaredField.getName())) continue;
                field = declaredField;
                continue block2;
            }
        }
        if (field != null) {
            if (!field.isAccessible()) {
                ((Field)field).setAccessible(true);
            }
            try {
                return ((Field)field).get(obj);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }
}

