/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.android.bci.util;

import com.appdynamics.android.bci.util.DefaultClassUtil;
import com.appdynamics.repackaged.asm.Type;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.List;

public interface ClassUtil {
    public String getCommonSuperClass(String var1, String var2);

    public ConstructorInfo getInformationAboutClass(String var1, List<Type> var2) throws ClassNotFoundException, NoSuchMethodException;

    public Class<?> toClazz(Type var1) throws ClassNotFoundException;

    public static class ConstructorInfo {
        private final int classAccess;
        private final boolean isNested;
        private final boolean isAnonymous;
        private final int constructorAccess;

        public ConstructorInfo(int classAccess, int constructorAccess, boolean isNested, boolean isAnonymous) {
            this.classAccess = classAccess;
            this.isNested = isNested;
            this.constructorAccess = constructorAccess;
            this.isAnonymous = isAnonymous;
        }

        public boolean isClassAndConstructorPublic() {
            return Modifier.isPublic(this.classAccess) && Modifier.isPublic(this.constructorAccess);
        }

        public boolean ifNestedIsClassStatic() {
            return !this.isNested || Modifier.isStatic(this.classAccess);
        }

        public boolean finalOrAnonymous() {
            return this.isAnonymous || Modifier.isFinal(this.classAccess);
        }

        public String toString() {
            return "classIs[public = " + this.toBool(Modifier.isPublic(this.classAccess)) + ", static = " + this.toBool(Modifier.isStatic(this.classAccess)) + ", final = " + this.toBool(Modifier.isFinal(this.classAccess)) + ", nested = " + this.toBool(this.isNested) + ", anonymous = " + this.toBool(this.isAnonymous) + "], constructorIs[public = " + this.toBool(Modifier.isPublic(this.constructorAccess)) + "]";
        }

        private String toBool(boolean b) {
            return b ? "yes" : "no";
        }
    }

    public static class Factory {
        public static ClassUtil createClassUtil(URL[] paths) {
            return new DefaultClassUtil(paths);
        }
    }
}

