/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.eumagent.runtime.networkrequests;

import ch.boye.httpclientandroidlib.Header;
import ch.boye.httpclientandroidlib.HttpRequest;
import ch.boye.httpclientandroidlib.HttpResponse;
import ch.boye.httpclientandroidlib.StatusLine;
import ch.boye.httpclientandroidlib.client.methods.HttpUriRequest;
import ch.boye.httpclientandroidlib.impl.client.RequestWrapper;
import com.appdynamics.eumagent.runtime.HttpRequestTracker;
import com.appdynamics.eumagent.runtime.Instrumentation;
import com.appdynamics.eumagent.runtime.ServerCorrelationHeaders;
import com.appdynamics.eumagent.runtime.logging.ADLog;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HttpClientAndroidLib {
    public static final String HTTP_CLIENT_ANDROID_LIB_INSTRUMENTATION_SOURCE = "AppDynamics.HttpClientAndroidLib";

    private static Map<String, List<String>> getHeaders(HttpResponse response) {
        return HttpClientAndroidLib.headersToMultiMap(response.getAllHeaders());
    }

    private static Map<String, List<String>> getHeaders(HttpRequest request) {
        return HttpClientAndroidLib.headersToMultiMap(request.getAllHeaders());
    }

    private static Map<String, List<String>> headersToMultiMap(Header[] headers) {
        HashMap<String, List<String>> multiMap = new HashMap<String, List<String>>();
        for (Header header : headers) {
            String name = header.getName();
            String value = header.getValue();
            multiMap.put(name, Collections.singletonList(value));
        }
        return multiMap;
    }

    public static class protocol {

        public static class HttpRequestExecutor {

            public static class execute {
                public static Object Enter(Object object, Object requestObject, Object connObject, Object contextObject) {
                    if (requestObject == null || connObject == null || contextObject == null) {
                        return null;
                    }
                    try {
                        HttpRequest request = (HttpRequest)requestObject;
                        Map headers = ServerCorrelationHeaders.generate();
                        for (Map.Entry header : headers.entrySet()) {
                            for (String value : (List)header.getValue()) {
                                request.addHeader((String)header.getKey(), value);
                            }
                        }
                    }
                    catch (Throwable e) {
                        ADLog.logAgentError((String)"Failed to add correlation headers.", (Throwable)e);
                    }
                    HttpRequestTracker tracker = null;
                    try {
                        RequestWrapper requestWrapper = (RequestWrapper)requestObject;
                        HttpUriRequest request = (HttpUriRequest)requestWrapper.getOriginal();
                        URI uri = request.getURI();
                        URL url = uri.toURL();
                        tracker = Instrumentation.beginHttpRequest((URL)url);
                        tracker.withInstrumentationSource(HttpClientAndroidLib.HTTP_CLIENT_ANDROID_LIB_INSTRUMENTATION_SOURCE);
                    }
                    catch (Throwable e) {
                        ADLog.logAgentError((String)"Failed to obtain URL to create tracker.", (Throwable)e);
                    }
                    try {
                        if (tracker != null) {
                            HttpRequest request = (HttpRequest)requestObject;
                            tracker.withRequestHeaderFields(HttpClientAndroidLib.getHeaders(request));
                        }
                    }
                    catch (Throwable e) {
                        ADLog.logAgentError((String)"Failed to transfer headers to tracker", (Throwable)e);
                    }
                    return tracker;
                }

                public static void Exit(Object object, Object returnedObject, Object scratchObject, Object requestObject, Object connObject, Object contextObject) {
                    HttpResponse response;
                    if (scratchObject == null) {
                        return;
                    }
                    HttpRequestTracker tracker = (HttpRequestTracker)scratchObject;
                    try {
                        if (returnedObject == null) {
                            tracker.withError("Request aborted").reportDone();
                            return;
                        }
                    }
                    catch (Throwable e) {
                        ADLog.logAgentError((String)"Failed to report aborted request.", (Throwable)e);
                        return;
                    }
                    Map headers = null;
                    try {
                        response = (HttpResponse)returnedObject;
                        headers = HttpClientAndroidLib.getHeaders(response);
                    }
                    catch (Throwable e) {
                        ADLog.logAgentError((String)"Failed to collect response headers.", (Throwable)e);
                    }
                    try {
                        response = (HttpResponse)returnedObject;
                        StatusLine statusLine = response.getStatusLine();
                        int responseCode = statusLine.getStatusCode();
                        String statusLinePhrase = null;
                        if (responseCode >= 400) {
                            statusLinePhrase = statusLine.getReasonPhrase();
                        }
                        tracker.withStatusLine(statusLinePhrase).withResponseCode(responseCode).withResponseHeaderFields(headers).reportDone();
                    }
                    catch (Throwable e) {
                        ADLog.logAgentError((String)"Failed to collect response data.", (Throwable)e);
                    }
                }

                public static void ThrowMe(Object object, Object scratchObject, IOException e) {
                    HttpRequestTracker tracker = (HttpRequestTracker)scratchObject;
                    try {
                        tracker.withException((Exception)e).reportDone();
                    }
                    catch (Throwable e1) {
                        ADLog.logAgentError((String)"Failed to report exception.", (Throwable)e1);
                    }
                }
            }
        }
    }
}

