/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.eumagent.runtime.networkrequests;

import com.appdynamics.eumagent.runtime.HttpRequestTracker;
import com.appdynamics.eumagent.runtime.Instrumentation;
import com.appdynamics.eumagent.runtime.ServerCorrelationHeaders;
import com.appdynamics.eumagent.runtime.logging.ADLog;
import com.squareup.okhttp.Headers;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OkHttp {
    public static final String OKHTTP_INSTRUMENTATION_SOURCE = "AppDynamics.OkHttpClient";
    private static final ThreadLocal<HttpRequestTracker> threadLocalTracker = new ThreadLocal();

    private static Map<String, List<String>> getHeaders(Response response) {
        return OkHttp.headersToMultiMap(response.headers());
    }

    private static Map<String, List<String>> getHeaders(com.squareup.okhttp.Request request) {
        return OkHttp.headersToMultiMap(request.headers());
    }

    private static Map<String, List<String>> headersToMultiMap(Headers headers) {
        HashMap<String, List<String>> multiMap = new HashMap<String, List<String>>();
        Set names = headers.names();
        for (String name : names) {
            List values = headers.values(name);
            multiMap.put(name, values);
        }
        return multiMap;
    }

    public static class Call {

        public static class getResponse {
            public static Object Enter(Object object, Object requestObject, boolean b) {
                HttpRequestTracker tracker = null;
                com.squareup.okhttp.Request request = null;
                try {
                    request = (com.squareup.okhttp.Request)requestObject;
                    URL url = request.url();
                    if (url != null) {
                        tracker = Instrumentation.beginHttpRequest((URL)url);
                        tracker.withInstrumentationSource(OkHttp.OKHTTP_INSTRUMENTATION_SOURCE);
                    }
                }
                catch (Throwable e) {
                    ADLog.logAgentError((String)"Failed to obtain URL to create tracker.", (Throwable)e);
                }
                try {
                    if (tracker != null) {
                        threadLocalTracker.set(tracker);
                        Map multiMap = OkHttp.getHeaders(request);
                        tracker.withRequestHeaderFields(multiMap);
                    }
                }
                catch (Throwable e) {
                    ADLog.logAgentError((String)"Failed to transfer headers to tracker.", (Throwable)e);
                }
                return tracker;
            }

            public static void Exit(Object object, Object returnedObject, Object scratchObject, Object requestObject, boolean b) {
                try {
                    HttpRequestTracker tracker = (HttpRequestTracker)scratchObject;
                    if (tracker == null) {
                        return;
                    }
                    threadLocalTracker.remove();
                    if (returnedObject == null) {
                        return;
                    }
                    com.squareup.okhttp.Request request = (com.squareup.okhttp.Request)requestObject;
                    Response response = (Response)returnedObject;
                    int responseCode = response.code();
                    String statusMessage = null;
                    if (responseCode >= 400) {
                        statusMessage = response.message();
                    }
                    tracker.withStatusLine(statusMessage).withResponseCode(responseCode);
                    Map multiMap = OkHttp.getHeaders(response);
                    tracker.withResponseHeaderFields(multiMap).reportDone();
                }
                catch (Throwable e) {
                    ADLog.logAgentError((String)"Failed to collect response data.", (Throwable)e);
                }
            }

            public static void ThrowMe(Object object, Object scratchObject, IOException e) {
                try {
                    HttpRequestTracker tracker = (HttpRequestTracker)scratchObject;
                    if (tracker == null) {
                        return;
                    }
                    tracker.withException((Exception)e).reportDone();
                    threadLocalTracker.remove();
                }
                catch (Throwable e1) {
                    ADLog.logAgentError((String)"Failed to report exception.", (Throwable)e1);
                }
            }
        }
    }

    public static class Request {

        public static class Builder {

            public static class build {
                public static Object Enter(Object object) {
                    if (Instrumentation.initializationStarted) {
                        try {
                            Request.Builder builder = (Request.Builder)object;
                            Map headers = ServerCorrelationHeaders.generate();
                            for (Map.Entry header : headers.entrySet()) {
                                for (String value : (List)header.getValue()) {
                                    builder.header((String)header.getKey(), value);
                                }
                            }
                        }
                        catch (Throwable e) {
                            ADLog.logAgentError((String)"Failed to add correlation headers.", (Throwable)e);
                        }
                    }
                    return null;
                }

                public static void Exit(Object object, Object returnedObject, Object scratchObject) {
                    try {
                        HttpRequestTracker tracker = (HttpRequestTracker)threadLocalTracker.get();
                        if (tracker == null) {
                            return;
                        }
                        com.squareup.okhttp.Request request = (com.squareup.okhttp.Request)returnedObject;
                        Map multimap = OkHttp.getHeaders(request);
                        tracker.withRequestHeaderFields(multimap);
                    }
                    catch (Throwable e) {
                        ADLog.logAgentError((String)"Failed to add request headers.", (Throwable)e);
                    }
                }
            }
        }
    }
}

