/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.android.bci.bytecodeinjectors;

import com.appdynamics.android.bci.bytecodeinjectors.BaseClassVisitor;
import com.appdynamics.android.bci.bytecodeinjectors.config.MethodCallMatcher;
import com.appdynamics.android.logging.BCIRunSummary;
import com.appdynamics.repackaged.asm.ClassVisitor;
import com.appdynamics.repackaged.asm.MethodVisitor;
import com.appdynamics.repackaged.asm.commons.Method;

public class ReplaceMethodCallInjector
extends BaseClassVisitor {
    private final MethodCallMatcher methodCallMatcher;
    private final Method replaceMethod;
    private final String featureName;

    public ReplaceMethodCallInjector(ClassVisitor delegate, MethodCallMatcher methodCallMatcher, Method replaceMethod, String featureName) {
        super(delegate);
        this.methodCallMatcher = methodCallMatcher;
        this.replaceMethod = replaceMethod;
        this.featureName = featureName;
    }

    @Override
    public MethodVisitor visitMethod(int access, String methodName, String methodDesc, String signature, String[] exceptions) {
        MethodVisitor baseMV = super.visitMethod(access, methodName, methodDesc, signature, exceptions);
        return new ReplaceMethodCallMethodVisitor(baseMV, access, methodName, methodDesc);
    }

    private class ReplaceMethodCallMethodVisitor
    extends BaseClassVisitor.BaseMethodVisitor {
        ReplaceMethodCallMethodVisitor(MethodVisitor mv, int access, String methodName, String methodDesc) {
            super(mv, access, methodName, methodDesc);
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            if (ReplaceMethodCallInjector.this.methodCallMatcher.isMethodCallMatched(opcode, owner, name, desc)) {
                BCIRunSummary.getDefaultInstance().featureInjected(ReplaceMethodCallInjector.this.featureName, ReplaceMethodCallInjector.this.className);
                ReplaceMethodCallInjector.this.logInjectedWithLineNumber("Instrumenting method: %s%s", this.methodName, this.methodDesc);
                this.instrumentationCallback(ReplaceMethodCallInjector.this.replaceMethod);
            } else {
                super.visitMethodInsn(opcode, owner, name, desc, itf);
            }
        }
    }
}

