/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.android.bci.classinjectors;

import com.appdynamics.android.logging.BCILogger;
import com.appdynamics.android.util.BuildUtils;
import com.appdynamics.repackaged.asm.ClassVisitor;
import com.appdynamics.repackaged.asm.ClassWriter;
import com.appdynamics.repackaged.asm.FieldVisitor;
import com.appdynamics.repackaged.asm.Label;
import com.appdynamics.repackaged.asm.Opcodes;
import com.appdynamics.repackaged.asm.Type;
import com.appdynamics.repackaged.asm.commons.GeneratorAdapter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class BuildInfoInjector
implements Opcodes {
    private static final String CLAZZ_NAME = "com/appdynamics/eumagent/runtime/BuildInfo";
    public static final String buildFieldPrefix = "appdynamicsGeneratedBuildId_";
    public static final String buildFieldForRuntime = "applicationBuildId";
    private final BCILogger logger = BCILogger.getLoggerFor(BuildInfoInjector.class);
    private final String buildId;

    public BuildInfoInjector(String buildId) {
        this.buildId = buildId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeBuildInfoClass(File classesDirectory) throws IOException {
        this.logger.info("Generating %s to store build ids at runtime.", CLAZZ_NAME);
        FileOutputStream out = null;
        try {
            ClassWriter writer = new ClassWriter(2);
            this.generateBuildInfoClass(writer);
            File file = new File(classesDirectory.getAbsolutePath() + File.separator + CLAZZ_NAME + ".class");
            if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                throw new IOException("Unable to create parent directory: " + file.getParentFile());
            }
            out = new FileOutputStream(file);
            out.write(writer.toByteArray());
            this.logger.info("Finished generating %s", CLAZZ_NAME);
            if (out == null) return;
        }
        catch (Exception ex) {
            try {
                throw new IOException(ex);
            }
            catch (Throwable throwable) {
                if (out == null) throw throwable;
                BuildUtils.closeQuietly(out);
                throw throwable;
            }
        }
        BuildUtils.closeQuietly(out);
        return;
    }

    private void generateBuildInfoClass(ClassWriter classVisitor) {
        classVisitor.visit(49, 4113, CLAZZ_NAME, null, "java/lang/Object", null);
        classVisitor.visitSource("BuildInfo.java", null);
        this.addDefaultConstructor(classVisitor);
        String runtimeDescriptor = Type.getDescriptor(String.class);
        FieldVisitor fv = classVisitor.visitField(4121, buildFieldForRuntime, runtimeDescriptor, null, this.buildId);
        fv.visitEnd();
        this.logger.info("Injected %s = %s", buildFieldForRuntime, this.buildId);
        classVisitor.visitEnd();
    }

    private void addDefaultConstructor(ClassVisitor classVisitor) {
        Label startConstructorLabel = new Label();
        Label endConstructorLabel = new Label();
        GeneratorAdapter mv = new GeneratorAdapter(classVisitor.visitMethod(1, "<init>", "()V", null, null), 1, "<init>", "()V");
        mv.visitLabel(startConstructorLabel);
        mv.visitIntInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
        mv.visitInsn(177);
        mv.visitLabel(endConstructorLabel);
        mv.visitMaxs(2, 1);
        mv.visitEnd();
    }
}

