/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.android.bci.bytecodeinjectors.config;

import com.appdynamics.android.bci.util.ClassUtil;
import com.appdynamics.android.logging.BCILogger;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.commons.Method;

public class MethodDefinitionMatcher {
    private static final BCILogger logger = BCILogger.getLoggerFor(MethodDefinitionMatcher.class);
    private final String targetClass;
    private final Map<String, Method> targetMethods;
    private final boolean matchSubclasses;
    private final ClassUtil classUtil;

    public MethodDefinitionMatcher(String targetClass, Method targetMethod, boolean matchSubclasses, ClassUtil classUtil) {
        this(targetClass, new Method[]{targetMethod}, matchSubclasses, classUtil);
    }

    public MethodDefinitionMatcher(String targetClass, Method[] targetMethods, boolean matchSubclasses, ClassUtil classUtil) {
        this.targetClass = targetClass;
        this.targetMethods = new HashMap<String, Method>();
        for (Method method : targetMethods) {
            this.targetMethods.put(method.getName() + method.getDescriptor(), method);
        }
        this.matchSubclasses = matchSubclasses;
        this.classUtil = classUtil;
    }

    public boolean matchesClass(String name) {
        if (this.targetClass == null) {
            return true;
        }
        if (this.targetClass.equals(name)) {
            return true;
        }
        if (this.matchSubclasses) {
            try {
                return this.targetClass.equals(this.classUtil.getCommonSuperClass(this.targetClass, name));
            }
            catch (RuntimeException e) {
                logger.warn("Unable to find common super class. owner: %s, matcher: %s. Exception: %s", name, this.targetClass, e);
                return false;
            }
        }
        return false;
    }

    public boolean matchesMethod(String methodName, String methodDesc) {
        if (this.targetMethods == null) {
            return true;
        }
        return this.targetMethods.containsKey(methodName + methodDesc);
    }
}

