/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.android.bci.util;

import com.appdynamics.android.bci.util.ClassInfo;
import com.appdynamics.android.bci.util.ClassUtil;
import com.appdynamics.android.bci.util.TypeHierarchy;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import org.objectweb.asm.Type;

public class DefaultClassUtil
implements ClassUtil {
    private final URLClassLoader classLoader;
    private final TypeHierarchy classHierarchy;

    public DefaultClassUtil(URL[] urls) {
        this.classLoader = new URLClassLoader(urls, ClassLoader.getSystemClassLoader().getParent());
        this.classHierarchy = new TypeHierarchy(this.classLoader);
    }

    @Override
    public String getCommonSuperClass(String type1, String type2) {
        try {
            ClassInfo c = this.classHierarchy.getClassInfo(type1);
            ClassInfo d = this.classHierarchy.getClassInfo(type2);
            return c.getCommonSuperClass(d).toBytecodeStyle();
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public ClassUtil.ConstructorInfo getInformationAboutClass(String type, List<Type> constructorArgTypes) throws ClassNotFoundException, NoSuchMethodException {
        Class<?> mainClazz = Class.forName(type, false, this.classLoader);
        Class[] argTypes = new Class[constructorArgTypes.size()];
        for (int i = 0; i < argTypes.length; ++i) {
            argTypes[i] = this.toClazz(constructorArgTypes.get(i));
        }
        Constructor<?> constructor = mainClazz.getDeclaredConstructor(argTypes);
        return new ClassUtil.ConstructorInfo(mainClazz.getModifiers(), constructor.getModifiers(), mainClazz.getEnclosingClass() != null || mainClazz.getEnclosingConstructor() != null || mainClazz.getEnclosingMethod() != null, mainClazz.isAnonymousClass());
    }

    @Override
    public Class<?> toClazz(Type type) throws ClassNotFoundException {
        if (type.getSort() == 9) {
            return Array.newInstance(this.toClazz(type.getElementType().getClassName()), new int[type.getDimensions()]).getClass();
        }
        return this.toClazz(type.getClassName());
    }

    private Class<?> toClazz(String clazz) throws ClassNotFoundException {
        if ("int".equals(clazz)) {
            return Integer.TYPE;
        }
        if ("double".equals(clazz)) {
            return Double.TYPE;
        }
        if ("long".equals(clazz)) {
            return Long.TYPE;
        }
        if ("float".equals(clazz)) {
            return Float.TYPE;
        }
        if ("byte".equals(clazz)) {
            return Byte.TYPE;
        }
        if ("short".equals(clazz)) {
            return Short.TYPE;
        }
        if ("boolean".equals(clazz)) {
            return Boolean.TYPE;
        }
        if ("char".equals(clazz)) {
            return Character.TYPE;
        }
        return Class.forName(clazz, false, this.classLoader);
    }
}

