/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.android.bci;

import com.appdynamics.android.bci.InjectorConfig;
import com.appdynamics.android.bci.bytecodeinjectors.BuildIdInjector;
import com.appdynamics.android.bci.bytecodeinjectors.JSRInliner;
import com.appdynamics.android.bci.classinjectors.BuildInfoInjector;
import com.appdynamics.android.bci.classinjectors.RuntimeCallbackInjector;
import com.appdynamics.android.bci.features.ActivityLifecycleTracking;
import com.appdynamics.android.bci.features.AdapterViewListenerTracking;
import com.appdynamics.android.bci.features.AndroidXFragmentLifecycleTracking;
import com.appdynamics.android.bci.features.ClassVisitorFactory;
import com.appdynamics.android.bci.features.CompositeClassVisitorFactory;
import com.appdynamics.android.bci.features.FragmentLifecycleTracking;
import com.appdynamics.android.bci.features.GenericTracking;
import com.appdynamics.android.bci.features.HttpClientTracking;
import com.appdynamics.android.bci.features.InfoPointTracking;
import com.appdynamics.android.bci.features.JavaScriptTracking;
import com.appdynamics.android.bci.features.URLConnectionTracking;
import com.appdynamics.android.bci.features.ViewGroupListenerTracking;
import com.appdynamics.android.bci.features.ViewListenerTracking;
import com.appdynamics.android.bci.features.WebChromeClientCrashCapture;
import com.appdynamics.android.bci.features.WebViewClientCrashCapture;
import com.appdynamics.android.bci.io.ClassFileRewriter;
import com.appdynamics.android.bci.io.ClassStreamRewriter;
import com.appdynamics.android.bci.io.IStreamFactory;
import com.appdynamics.android.bci.io.JarFileRewriter;
import com.appdynamics.android.bci.io.StreamFactory;
import com.appdynamics.android.bci.util.ClassUtil;
import com.appdynamics.android.bci.util.VersionLoader;
import com.appdynamics.android.logging.BCILogger;
import com.appdynamics.android.logging.BCIRunSummary;
import com.appdynamics.android.util.BuildUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.UUID;
import org.objectweb.asm.ClassVisitor;

public class Injector {
    private static final BCILogger logger = BCILogger.getLoggerFor(Injector.class);
    private final CompositeClassVisitorFactory adapterFactory;
    private final InjectorConfig config;
    private final BuildInfoInjector buildInfoInjector;
    private final RuntimeCallbackInjector runtimeCallbackInjector;
    private final ClassStreamRewriter streamRewriter;
    private final IStreamFactory streamFactory;
    private final String injectorVersion = new VersionLoader().loadVersion();
    private final String buildId;

    private static void usage(String msg) {
        String prog = System.getProperty("sun.java.command");
        System.err.println(prog + ": " + msg);
        System.err.println("usage: java -jar injector.jar <path> [options] [optional libraries...]");
        System.err.println("  options:");
        System.err.println("    -i <file>                    : YML file describing interceptor, can be used multiple times");
        System.err.println("    -x <pattern>                 : Classes to be excluded from injection, can be used multiple times");
        System.err.println("    --enableWebViewCrashReporting: Instrument crash reporting for WebView objects");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            Injector.usage("no arguments?");
        } else {
            File logFileDir = new File(System.getProperty("java.io.tmpdir"), "Appd-androidbci_" + System.currentTimeMillis());
            logFileDir.mkdirs();
            BCILogger.setBciLogger(new BCILogger.MultiLogger(logFileDir){

                @Override
                protected void _log(BCILogger.Level level, String msg) {
                    if (level == BCILogger.Level.INFO) {
                        System.out.println("[INFO] " + msg);
                    }
                }
            });
            System.out.println("Logs are available at: " + logFileDir);
            InjectorConfig config = new InjectorConfig();
            ArrayList<URL> urls = new ArrayList<URL>();
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-i")) {
                    if (++i >= args.length) {
                        Injector.usage("-i: requires argument");
                        return;
                    }
                    config.addInterceptorFiles(args[i]);
                    continue;
                }
                if (args[i].equals("-x")) {
                    if (++i >= args.length) {
                        Injector.usage("-x: requires argument");
                        return;
                    }
                    config.addExcludedClasses(args[i]);
                    continue;
                }
                if (args[i].equalsIgnoreCase("--enableWebViewCrashReporting")) {
                    config.setWebViewCallbackCrashReportingEnabled(true);
                    continue;
                }
                urls.add(new File(args[i]).toURI().toURL());
            }
            ClassUtil classUtil = ClassUtil.Factory.createClassUtil(urls.toArray(new URL[0]));
            Injector injector = new Injector(classUtil, config);
            injector.printStartSummary();
            File rootFolder = new File(args[0]);
            if (!rootFolder.isDirectory()) {
                Injector.usage(String.format("path: is not a directory: %s", args[0]));
                return;
            }
            try {
                injector.instrumentClassFiles(rootFolder);
            }
            finally {
                injector.writeExtraClassesIntoDirectory(rootFolder);
                injector.printRunSummary();
            }
        }
    }

    public Injector(ClassUtil classUtil, InjectorConfig config) {
        if (config == null) {
            config = new InjectorConfig();
        }
        this.config = config;
        this.streamFactory = new StreamFactory();
        logger.debug("Initializing ClassStreamRewriter.", new Object[0]);
        logger.info("Injector version = " + this.injectorVersion, new Object[0]);
        logger.debug("Using config = %s", config);
        this.buildId = UUID.randomUUID().toString();
        this.buildInfoInjector = new BuildInfoInjector(this.buildId);
        this.runtimeCallbackInjector = new RuntimeCallbackInjector();
        this.adapterFactory = new CompositeClassVisitorFactory();
        this.adapterFactory.addFactory(new ClassVisitorFactory(){

            @Override
            public ClassVisitor createClassVisitor(ClassVisitor delegate) {
                return new JSRInliner(delegate);
            }
        });
        this.adapterFactory.addFactory(new URLConnectionTracking(classUtil));
        this.adapterFactory.addFactory(new HttpClientTracking(classUtil));
        this.adapterFactory.addFactory(new GenericTracking(this.runtimeCallbackInjector, config.getInterceptorFiles()));
        this.adapterFactory.addFactory(new ActivityLifecycleTracking(classUtil));
        this.adapterFactory.addFactory(new FragmentLifecycleTracking(classUtil));
        this.adapterFactory.addFactory(new AndroidXFragmentLifecycleTracking(classUtil));
        this.adapterFactory.addFactory(new ViewGroupListenerTracking(classUtil));
        this.adapterFactory.addFactory(new ViewListenerTracking(classUtil));
        this.adapterFactory.addFactory(new AdapterViewListenerTracking(classUtil));
        this.adapterFactory.addFactory(new JavaScriptTracking(classUtil));
        this.adapterFactory.addFactory(new InfoPointTracking());
        if (config.isWebViewCallbackCrashReportingEnabled()) {
            this.adapterFactory.addFactory(new WebViewClientCrashCapture(classUtil));
            this.adapterFactory.addFactory(new WebChromeClientCrashCapture(classUtil));
        }
        this.adapterFactory.addFactory(new BuildIdInjector.Factory(classUtil, this.buildId));
        this.streamRewriter = new ClassStreamRewriter(this.adapterFactory, config, classUtil);
    }

    public void writeExtraClassesIntoDirectory(File classesDirectory) {
        try {
            this.buildInfoInjector.writeBuildInfoClass(classesDirectory);
            this.runtimeCallbackInjector.writeRuntimeCallbacks(classesDirectory);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void printStartSummary() {
        BCILogger.getBciLogger().info("\n\n\t\t\t%s\n\n", BuildUtils.encloseInBanner("Starting AppDynamics BCI Instrumentation", '=').replaceAll("\n", "\n\t\t\t"));
    }

    public void instrumentJar(File outJarFile, File inJarFile) throws IOException {
        JarFileRewriter jarFileRewriter = new JarFileRewriter(outJarFile, inJarFile, this.streamRewriter, this.streamFactory);
        jarFileRewriter.rewrite();
    }

    public void instrumentClassFiles(File directory) throws IOException {
        ClassFileRewriter classFilesRewriter = new ClassFileRewriter(directory, this.streamRewriter, this.streamFactory);
        classFilesRewriter.rewrite();
    }

    public void printRunSummary() {
        BCIRunSummary.getDefaultInstance().printSummary();
    }

    public String getBuildId() {
        return this.buildId;
    }
}

