/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.android.bci.bytecodeinjectors;

import com.appdynamics.android.bci.bytecodeinjectors.BaseClassVisitor;
import com.appdynamics.android.bci.features.ClassVisitorFactory;
import com.appdynamics.android.bci.util.ClassUtil;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public class BuildIdInjector
extends BaseClassVisitor {
    private static final String ACTIVITY_CLASS = "android/app/Activity";
    private static final String CLASS_INIT_METHOD = "<clinit>";
    private static final String CLASS_INIT_METHOD_DESCRIPTOR = "()V";
    private static final String BUILD_INFO_CLASS = "com/appdynamics/eumagent/runtime/BuildInfo";
    private static final String BUILD_ID_FIELD_PREFIX = "appdynamicsGeneratedBuildId_";
    private static final String THROWABLE_CLASS = "java/lang/Throwable";
    private boolean isTargetClass;
    private boolean hasSeenClassInitMethod;
    private final ClassUtil classUtil;
    private final String buildId;

    public BuildIdInjector(ClassVisitor cv, ClassUtil classUtil, String buildId) {
        super(cv);
        this.classUtil = classUtil;
        this.buildId = buildId;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.hasSeenClassInitMethod = false;
        boolean bl = this.isTargetClass = !name.startsWith("android/") && superName.startsWith("android/") && this.classUtil.getCommonSuperClass(ACTIVITY_CLASS, name).equals(ACTIVITY_CLASS);
        if (this.isTargetClass) {
            this.logger.debug("Found a descendant of %s class: %s", ACTIVITY_CLASS, this.className);
        }
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor baseMV = super.visitMethod(access, name, desc, signature, exceptions);
        return baseMV;
    }

    public void visitEnd() {
        if (this.isTargetClass && !this.hasSeenClassInitMethod) {
            this.logger.debug("Did not find <clinit> method for class %s, adding it", this.className);
            MethodVisitor baseMV = super.visitMethod(8, CLASS_INIT_METHOD, CLASS_INIT_METHOD_DESCRIPTOR, null, null);
            BuildIdInjectorMethodVisitor injectorMV = new BuildIdInjectorMethodVisitor(baseMV, 8, CLASS_INIT_METHOD, CLASS_INIT_METHOD_DESCRIPTOR);
            injectorMV.visitCode();
            injectorMV.visitInsn(177);
            injectorMV.visitMaxs(0, 0);
            injectorMV.visitEnd();
        }
        super.visitEnd();
    }

    public static class Factory
    implements ClassVisitorFactory {
        private final ClassUtil classUtil;
        private final String id;

        public Factory(ClassUtil classUtil, String id) {
            this.classUtil = classUtil;
            this.id = id;
        }

        @Override
        public ClassVisitor createClassVisitor(ClassVisitor delegate) {
            return new BuildIdInjector(delegate, this.classUtil, this.id);
        }
    }

    private class BuildIdInjectorMethodVisitor
    extends BaseClassVisitor.BaseMethodVisitor {
        private final Label tryStartLabel;
        private final Label tryEndLabel;
        private final Label catchStartLabel;
        private final Label catchEndLabel;

        BuildIdInjectorMethodVisitor(MethodVisitor mv, int access, String methodName, String methodDesc) {
            super(mv, access, methodName, methodDesc);
            this.tryStartLabel = new Label();
            this.tryEndLabel = new Label();
            this.catchStartLabel = new Label();
            this.catchEndLabel = new Label();
        }

        public void visitCode() {
        }
    }
}

