/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.android.bci.features;

import com.appdynamics.android.bci.bytecodeinjectors.ReplaceMethodCallInjector;
import com.appdynamics.android.bci.bytecodeinjectors.WrapMethodCallInjector;
import com.appdynamics.android.bci.bytecodeinjectors.config.MethodCallMatcher;
import com.appdynamics.android.bci.features.ClassVisitorFactory;
import com.appdynamics.android.bci.util.ClassUtil;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.commons.Method;

public class URLConnectionTracking
implements ClassVisitorFactory {
    private static final String FEATURE = "URL_HTTP";
    private static final String URL_CONNECTION = "java/net/URLConnection";
    private static final String HTTP_URL_CONNECTION = "java/net/HttpURLConnection";
    private static final String HTTPS_URL_CONNECTION = "javax/net/ssl/HttpsURLConnection";
    private static final String IO_EXCEPTION = "java/io/IOException";
    private static final String[] URL_CONNECTION_CLASSES = new String[]{"java/net/URLConnection", "java/net/HttpURLConnection", "javax/net/ssl/HttpsURLConnection"};
    private static final Method[] METHODS_THAT_CONNECT_AND_READ_BYTES = new Method[]{Method.getMethod((String)"java.lang.Object getContent()"), Method.getMethod((String)"java.lang.Object getContent(Class[])"), Method.getMethod((String)"java.lang.String getContentEncoding()"), Method.getMethod((String)"int getContentLength()"), Method.getMethod((String)"java.lang.String getContentType()"), Method.getMethod((String)"long getDate()"), Method.getMethod((String)"long getExpiration()"), Method.getMethod((String)"long getLastModified()"), Method.getMethod((String)"long getHeaderFieldDate(java.lang.String, long)"), Method.getMethod((String)"java.util.Map getHeaderFields()"), Method.getMethod((String)"java.lang.String getHeaderFieldKey(int)"), Method.getMethod((String)"java.lang.String getHeaderField(int)"), Method.getMethod((String)"java.lang.String getHeaderField(java.lang.String)"), Method.getMethod((String)"int getHeaderFieldInt(java.lang.String, int)"), Method.getMethod((String)"java.lang.String getResponseMessage()"), Method.getMethod((String)"int getResponseCode()")};
    private static final Method[] METHODS_THAT_WOULD_TRIGGER_REQUEST = new Method[]{Method.getMethod((String)"void connect()"), Method.getMethod((String)"java.io.OutputStream getOutputStream()")};
    private static final Method GET_INPUT_STREAM = Method.getMethod((String)"java.io.InputStream getInputStream()");
    private static final Method GET_ERROR_STREAM = Method.getMethod((String)"java.io.InputStream getErrorStream()");
    private static final Method REQUEST_ABOUT_TO_BE_SENT = Method.getMethod((String)"void requestAboutToBeSent(java.net.URLConnection)");
    private static final Method REQUEST_SENT = Method.getMethod((String)"void requestSent(java.net.URLConnection)");
    private static final Method REQUEST_HARVESTABLE = Method.getMethod((String)"void requestHarvestable(java.net.URLConnection)");
    private static final Method NETWORK_ERROR = Method.getMethod((String)"void networkError(java.net.URLConnection, java.io.IOException)");
    private static final Method GET_INPUT_STREAM_CALLBACK = Method.getMethod((String)"java.io.InputStream getInputStream(java.net.URLConnection)");
    private static final Method GET_ERROR_STREAM_CALLBACK = Method.getMethod((String)"java.io.InputStream getErrorStream(java.net.HttpURLConnection)");
    private final ClassUtil classUtil;

    public URLConnectionTracking(ClassUtil classUtil) {
        this.classUtil = classUtil;
    }

    @Override
    public ClassVisitor createClassVisitor(ClassVisitor delegate) {
        for (String targetClass : URL_CONNECTION_CLASSES) {
            delegate = new WrapMethodCallInjector(delegate, FEATURE, new MethodCallMatcher(targetClass, METHODS_THAT_CONNECT_AND_READ_BYTES, false, this.classUtil), REQUEST_ABOUT_TO_BE_SENT, REQUEST_HARVESTABLE, NETWORK_ERROR, IO_EXCEPTION, true);
            delegate = new WrapMethodCallInjector(delegate, FEATURE, new MethodCallMatcher(targetClass, METHODS_THAT_WOULD_TRIGGER_REQUEST, false, this.classUtil), REQUEST_ABOUT_TO_BE_SENT, REQUEST_SENT, NETWORK_ERROR, IO_EXCEPTION, true);
            delegate = new ReplaceMethodCallInjector(delegate, new MethodCallMatcher(targetClass, GET_INPUT_STREAM, false, this.classUtil), GET_INPUT_STREAM_CALLBACK, FEATURE);
            delegate = new ReplaceMethodCallInjector(delegate, new MethodCallMatcher(targetClass, GET_ERROR_STREAM, false, this.classUtil), GET_ERROR_STREAM_CALLBACK, FEATURE);
        }
        return delegate;
    }
}

