/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.android.bci.io;

import com.appdynamics.android.bci.Injector;
import com.appdynamics.android.bci.io.ClassStreamRewriter;
import com.appdynamics.android.bci.io.IStreamFactory;
import com.appdynamics.android.logging.BCILogger;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class JarFileRewriter {
    private static final int BUFFER_SIZE = 8192;
    private static final BCILogger logger = BCILogger.getLoggerFor(Injector.class);
    private static final HashSet<String> classMap = new HashSet();
    private final File outJarFile;
    private final File inJarFile;
    private final ClassStreamRewriter rewriter;
    private final IStreamFactory streamFactory;
    private final byte[] buffer;
    private final JarOutputStream jos;

    public JarFileRewriter(File outJarFile, File inJarFile, ClassStreamRewriter rewriter, IStreamFactory streamFactory) {
        this.outJarFile = outJarFile;
        this.inJarFile = inJarFile;
        this.rewriter = rewriter;
        this.streamFactory = streamFactory;
        this.buffer = new byte[8192];
        this.jos = null;
    }

    public JarFileRewriter(JarOutputStream jos, File inJarFile, ClassStreamRewriter rewriter, IStreamFactory streamFactory) {
        this.jos = jos;
        this.outJarFile = null;
        this.inJarFile = inJarFile;
        this.rewriter = rewriter;
        this.streamFactory = streamFactory;
        this.buffer = new byte[8192];
    }

    public void rewrite() throws IOException {
        ZipInputStream is = null;
        ZipOutputStream os = null;
        try {
            is = this.streamFactory.getJarInputStream(this.streamFactory.getInputStream(this.inJarFile));
            os = this.jos == null ? this.streamFactory.getJarOutputStream(this.streamFactory.getOutputStream(this.outJarFile), ((JarInputStream)is).getManifest()) : this.jos;
            this.rewrite((JarOutputStream)os, (JarInputStream)is);
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null && this.jos == null) {
                os.close();
            }
        }
    }

    private void rewrite(JarOutputStream out, JarInputStream in) throws IOException {
        JarEntry entry;
        while ((entry = in.getNextJarEntry()) != null) {
            JarEntry outEntry = new JarEntry(entry.getName());
            if (this.putEntry(outEntry, out)) {
                if (!entry.isDirectory() && entry.getName().endsWith(".class")) {
                    this.rewriter.readInput(in);
                    this.rewriter.writeOutput(out);
                } else if (!entry.isDirectory()) {
                    int numRead;
                    while ((numRead = in.read(this.buffer, 0, 8192)) != -1) {
                        out.write(this.buffer, 0, numRead);
                    }
                }
            }
            out.closeEntry();
        }
    }

    private boolean putEntry(JarEntry entry, JarOutputStream jos) {
        try {
            if (classMap.contains(entry.getName())) {
                logger.info("duplicate file %s ignoring in jar.", entry.getName());
                return false;
            }
            jos.putNextEntry(entry);
            classMap.add(entry.getName());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

