/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.android.ant;

import com.appdynamics.android.bci.Injector;
import com.appdynamics.android.bci.InjectorConfig;
import com.appdynamics.android.bci.util.ClassUtil;
import com.appdynamics.android.logging.BCILogger;
import com.appdynamics.android.util.BuildUtils;
import com.appdynamics.android.util.OutputLocator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;

public class EUMAgentInjectorTask
extends Task {
    private String classFilesPath;
    private Reference jarFilesRefId;
    private String outputLocation;
    private String instrumentationJarLocation;
    private String androidJarLocation;
    private List<FileSet> fileSetsToExclude = new ArrayList<FileSet>();
    private List<Interceptor> interceptorList = new ArrayList<Interceptor>();

    public void setClassFilesPath(String path) {
        this.classFilesPath = path;
    }

    public void setJarFilesRefId(Reference refId) {
        this.jarFilesRefId = refId;
    }

    public void setOutputLocation(String location) {
        this.outputLocation = location;
    }

    public void setInstrumentationJarLocation(String location) {
        this.instrumentationJarLocation = location;
    }

    public void setAndroidJarLocation(String location) {
        this.androidJarLocation = location;
    }

    public void add(FileSet set) {
        this.fileSetsToExclude.add(set);
    }

    public Interceptor createInterceptor() {
        Interceptor interceptor = new Interceptor();
        this.interceptorList.add(interceptor);
        return interceptor;
    }

    private static int asInt(BCILogger.Level level) {
        switch (level) {
            case TRACE: {
                return 3;
            }
            case DEBUG: {
                return 4;
            }
            case WARN: {
                return 1;
            }
            case ERROR: {
                return 0;
            }
        }
        return 2;
    }

    private File getLogDir() {
        File outputDir = new File(this.outputLocation).getParentFile();
        if (!outputDir.exists() && !outputDir.mkdirs()) {
            throw new BuildException("Unable to create directory: " + outputDir);
        }
        return outputDir;
    }

    public void init() throws BuildException {
    }

    public void execute() throws BuildException {
        this.checkPreconditions();
        File outputDir = new File(this.outputLocation);
        try {
            BuildUtils.prepareOutputDirectory(outputDir);
        }
        catch (Exception e) {
            throw new BuildException("Error preparing output directory", (Throwable)e);
        }
        try {
            BCILogger.setBciLogger(new AntLogger());
        }
        catch (FileNotFoundException e) {
            throw new BuildException((Throwable)e);
        }
        Object o = this.jarFilesRefId.getReferencedObject(this.getProject());
        File classFilesPathFile = new File(this.classFilesPath);
        if (o instanceof ResourceCollection) {
            ResourceCollection c = (ResourceCollection)o;
            Iterator i = c.iterator();
            ArrayList<File> jarFiles = new ArrayList<File>();
            ArrayList<URL> classPathsAsURLS = new ArrayList<URL>();
            try {
                while (i.hasNext()) {
                    Object obj = i.next();
                    File file = new File(obj.toString());
                    jarFiles.add(file);
                    classPathsAsURLS.add(file.toURI().toURL());
                }
                File androidJarFile = new File(this.androidJarLocation);
                classPathsAsURLS.add(androidJarFile.toURI().toURL());
                classPathsAsURLS.add(classFilesPathFile.toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new BuildException((Throwable)e);
            }
            URL[] urls = classPathsAsURLS.toArray(new URL[classPathsAsURLS.size()]);
            ClassUtil classUtil = ClassUtil.Factory.createClassUtil(urls);
            InjectorConfig config = new InjectorConfig();
            if (this.interceptorList.size() > 0) {
                for (Interceptor interceptor : this.interceptorList) {
                    config.addInterceptorFiles(interceptor.file);
                }
            }
            Injector injector = new Injector(classUtil, config);
            injector.printStartSummary();
            OutputLocator locator = new OutputLocator(new File(this.outputLocation));
            LinkedHashMap<File, File> inputToOutputFileMap = new LinkedHashMap<File, File>();
            for (File f : jarFiles) {
                inputToOutputFileMap.put(f, locator.getOutputLocation());
            }
            Path newPath = new Path(this.getProject());
            BCILogger bciLogger = BCILogger.getBciLogger();
            bciLogger.info("Location of android.jar = %s", this.androidJarLocation);
            for (File f : jarFiles) {
                File outputFile = (File)inputToOutputFileMap.get(f);
                Path path = new Path(this.getProject());
                path.setLocation(outputFile);
                newPath.add(path);
                if (this.shouldDoBCIOn(f)) {
                    bciLogger.info("Rewriting %s to %s", f.getAbsoluteFile(), outputFile.getAbsoluteFile());
                    try {
                        injector.instrumentJar(outputFile, f);
                    }
                    catch (Throwable e) {
                        this.handleFatalException("Error rewriting " + f.getAbsoluteFile() + " to " + outputFile.getAbsoluteFile() + ": " + e.getMessage(), e);
                    }
                    continue;
                }
                bciLogger.info("Copying %s to %s", f.getAbsoluteFile(), outputFile.getAbsoluteFile());
                try {
                    BuildUtils.copyFile(outputFile, f);
                }
                catch (Throwable e) {
                    this.handleFatalException("Error copying " + f.getAbsoluteFile() + " to " + outputFile.getAbsoluteFile() + ": " + e.getMessage(), e);
                }
            }
            this.getProject().addReference(this.jarFilesRefId.getRefId(), (Object)newPath);
            try {
                injector.instrumentClassFiles(classFilesPathFile);
                injector.writeExtraClassesIntoDirectory(classFilesPathFile);
                injector.printRunSummary();
            }
            catch (IOException e) {
                this.handleFatalException("Error performing byte code injection", e);
            }
        } else {
            throw new BuildException("jarFilesRefId is not a resource collection");
        }
    }

    private void checkPreconditions() throws BuildException {
        this.throwIfNull(this.classFilesPath, "classfilespath");
        this.throwIfNull(this.instrumentationJarLocation, "instrumentationjarlocation");
        this.throwIfNull(this.androidJarLocation, "androidjarlocation");
        this.throwIfNull(this.jarFilesRefId, "jarfilesrefid");
        this.throwIfNull(this.outputLocation, "outputlocation");
        this.log("Path to class files: " + this.classFilesPath);
        this.log("Path to instrumentation jar: " + this.instrumentationJarLocation);
        this.log("Path to Android jar: " + this.androidJarLocation);
        if (this.interceptorList.size() > 0) {
            StringBuilder sb = new StringBuilder("Interceptors to use:");
            sb.append(System.lineSeparator());
            for (Interceptor iFile : this.interceptorList) {
                sb.append("  - ").append(iFile.file).append(System.lineSeparator());
            }
            this.log(sb.toString());
        }
    }

    private void throwIfNull(Object var, String prop) throws BuildException {
        if (var == null) {
            throw new BuildException("Required property " + prop + " not set.");
        }
    }

    private void handleFatalException(String message, Throwable e) throws BuildException {
        BCILogger.getBciLogger().error(message, e);
        throw new BuildException(message, e);
    }

    private boolean shouldDoBCIOn(File f) {
        File instrumentationJar = new File(this.instrumentationJarLocation);
        if (f.getAbsolutePath().equals(instrumentationJar.getAbsolutePath())) {
            return false;
        }
        for (FileSet fs : this.fileSetsToExclude) {
            for (Object resource : fs) {
                File resourceFile;
                if (!(resource instanceof FileResource) || !(resourceFile = ((FileResource)resource).getFile()).getAbsolutePath().equals(f.getAbsolutePath())) continue;
                return false;
            }
        }
        return true;
    }

    public static class Interceptor {
        String file;

        public void setFile(String file) {
            this.file = file;
        }

        public String getFile() {
            return this.file;
        }
    }

    private class AntLogger
    extends BCILogger.MultiLogger {
        protected AntLogger() throws FileNotFoundException {
            super(EUMAgentInjectorTask.this.getLogDir());
        }

        @Override
        protected void _log(BCILogger.Level level, String msg) {
            EUMAgentInjectorTask.this.log(msg, EUMAgentInjectorTask.asInt(level));
        }
    }
}

