/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.android.bci;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;

public class InjectorConfig
implements Serializable {
    private static final long serialVersionUID = -5124028465010634779L;
    private Set<String> interceptorFiles = new HashSet<String>(Arrays.asList("okhttp", "httpclientandroidlib"));
    private Set<Pattern> exclusionPatterns = new HashSet<Pattern>();
    private Set<String> exclusionStrings = new HashSet<String>();
    private Set<Pattern> inclusionPatterns = new HashSet<Pattern>();
    private Set<String> inclusionStrings = new HashSet<String>();
    private static final Set<String> ootbExclusionPatternStrings = new HashSet<String>(Arrays.asList("org/apache/http/.*", "java/net/URLConnection/.*", "java/net/HttpURLConnection/.*", "javax/net/ssl/HttpsURLConnection/.*", "com/google/firebase/.*"));
    private static Pattern ootbExclusionPattern;
    private boolean webViewCallbackCrashReportingEnabled = false;

    public InjectorConfig() {
        this.exclusionPatterns.add(ootbExclusionPattern);
    }

    public void addInterceptorFiles(String file) {
        if (file == null) {
            return;
        }
        if (!this.interceptorFiles.contains(file)) {
            this.interceptorFiles.add(file);
        }
    }

    public Set<String> getInterceptorFiles() {
        return this.interceptorFiles;
    }

    private String glob2regex(String glob) {
        glob = glob.trim();
        StringBuilder sb = new StringBuilder();
        block6: for (int i = 0; i < glob.length(); ++i) {
            char c = glob.charAt(i);
            switch (c) {
                case '.': {
                    sb.append('/');
                    continue block6;
                }
                case '*': {
                    if (i + 1 == glob.length() || glob.charAt(i + 1) != '*') {
                        sb.append("[^/]*");
                        continue block6;
                    }
                    if (glob.charAt(i + 1) != '*') continue block6;
                    sb.append(".*");
                    ++i;
                    continue block6;
                }
                case '$': {
                    sb.append("\\$");
                    continue block6;
                }
                case '?': {
                    sb.append('.');
                    continue block6;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public void addExcludedClasses(String pattern) {
        if (pattern == null) {
            return;
        }
        String regexPattern = this.glob2regex(pattern);
        Pattern pat = Pattern.compile("^" + regexPattern + "$");
        this.exclusionPatterns.add(pat);
        this.exclusionStrings.add(regexPattern);
    }

    public void addIncludedClasses(String pattern) {
        if (pattern == null) {
            return;
        }
        String regexPattern = this.glob2regex(pattern);
        Pattern pat = Pattern.compile("^" + regexPattern + "$");
        this.inclusionPatterns.add(pat);
        this.inclusionStrings.add(regexPattern);
    }

    public Set<Pattern> getExclusionPatterns() {
        return this.exclusionPatterns;
    }

    public Set<String> getExclusionStrings() {
        return this.exclusionStrings;
    }

    public Set<Pattern> getInclusionPatterns() {
        return this.inclusionPatterns;
    }

    public Set<String> getInclusionStrings() {
        return this.inclusionStrings;
    }

    public boolean isWebViewCallbackCrashReportingEnabled() {
        return this.webViewCallbackCrashReportingEnabled;
    }

    public void setWebViewCallbackCrashReportingEnabled(boolean enable) {
        this.webViewCallbackCrashReportingEnabled = enable;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("InjectorConfig{");
        sb.append(", interceptorFiles=" + this.interceptorFiles);
        sb.append(", webViewCallbackCrashReportingEnabled=").append(this.webViewCallbackCrashReportingEnabled);
        sb.append(", ootbExclusionPatternStrings=").append(ootbExclusionPatternStrings.toString());
        sb.append(", exclusionStrings=").append(this.exclusionStrings.toString());
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InjectorConfig that = (InjectorConfig)o;
        return this.webViewCallbackCrashReportingEnabled == that.webViewCallbackCrashReportingEnabled && Objects.equals(this.interceptorFiles, that.interceptorFiles) && Objects.equals(this.exclusionPatterns, that.exclusionPatterns) && Objects.equals(this.exclusionStrings, that.exclusionStrings) && Objects.equals(this.inclusionPatterns, that.inclusionPatterns) && Objects.equals(this.inclusionStrings, that.inclusionStrings);
    }

    public int hashCode() {
        return Objects.hash(this.interceptorFiles, this.exclusionPatterns, this.exclusionStrings, this.inclusionPatterns, this.inclusionStrings, this.webViewCallbackCrashReportingEnabled);
    }

    static {
        StringBuilder ootbPattern = new StringBuilder();
        ootbPattern.append("^(?:");
        Boolean first = true;
        for (String pat : ootbExclusionPatternStrings) {
            if (first.booleanValue()) {
                first = false;
            } else {
                ootbPattern.append('|');
            }
            ootbPattern.append(pat);
        }
        ootbPattern.append(")$");
        ootbExclusionPattern = Pattern.compile(ootbPattern.toString());
    }
}

