/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.android.bci.bytecodeinjectors;

import com.appdynamics.android.bci.bytecodeinjectors.BaseClassVisitor;
import com.appdynamics.android.bci.util.ClassUtil;
import com.appdynamics.android.logging.BCIRunSummary;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class LifecycleCallbacksInjector
extends BaseClassVisitor {
    private final BCIRunSummary bciSummary = BCIRunSummary.getDefaultInstance();
    private final String rootClassName;
    private boolean isInterestingClass;
    private final ClassUtil classUtil;
    private Set<Lifecycle> methodPresent;
    private String superName;
    public static final String VOID_RETURN_NO_PARAM = "()V";
    private Map<String, Lifecycle> lifecycleMap;

    public LifecycleCallbacksInjector(ClassVisitor classVisitor, ClassUtil classUtil, String rootClassName, Map<String, Lifecycle> lifecycleMap) {
        super(classVisitor);
        this.rootClassName = rootClassName;
        this.classUtil = classUtil;
        this.lifecycleMap = lifecycleMap;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        boolean bl = this.isInterestingClass = !name.startsWith("androidx/") && !name.startsWith("android/") && superName.startsWith(this.rootClassName.split("/")[0]) && this.classUtil.getCommonSuperClass(this.rootClassName, name).equals(this.rootClassName);
        if (this.isInterestingClass) {
            this.logInjectedWithLineNumber("Found a descendant of %s class: %s", this.rootClassName, this.className);
            this.methodPresent = new HashSet<Lifecycle>();
            this.superName = superName;
        }
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        Lifecycle lifecycle;
        MethodVisitor nextVisitor = super.visitMethod(access, name, desc, signature, exceptions);
        if (nextVisitor != null && this.isInterestingClass && (lifecycle = this.lifecycleMap.get(name)) != null && lifecycle.methodDesc.equals(desc)) {
            this.bciSummary.featureInjected("ANR", this.className);
            this.methodPresent.add(lifecycle);
            return new LifecycleMethodVisitor(access, name, nextVisitor, desc, lifecycle);
        }
        return new BaseClassVisitor.BaseMethodVisitor(nextVisitor, access, name, desc);
    }

    public void visitEnd() {
        Set<Lifecycle> methodsNotImplemented;
        if (this.isInterestingClass && !(methodsNotImplemented = this.getMethodsNotImplemented()).isEmpty()) {
            this.bciSummary.featureInjected("ANR", this.className);
            for (Lifecycle toAdd : methodsNotImplemented) {
                MethodVisitor mv = super.visitMethod(toAdd.access, toAdd.methodName, toAdd.methodDesc, null, null);
                mv.visitCode();
                this.injectCallback(mv, toAdd);
                mv.visitVarInsn(25, 0);
                Type[] originalArguments = Type.getArgumentTypes((String)toAdd.methodDesc);
                for (int i = 0; i < originalArguments.length; ++i) {
                    mv.visitVarInsn(25, i + 1);
                }
                mv.visitMethodInsn(183, this.superName, toAdd.methodName, toAdd.methodDesc, false);
                Type returnType = Type.getReturnType((String)toAdd.methodDesc);
                int returnOpCode = this.opcodeForReturnOfType(returnType);
                this.logger.info("returnOpCode: " + returnOpCode, new Object[0]);
                mv.visitInsn(returnOpCode);
                mv.visitEnd();
                this.logInjectedWithLineNumber("Finished injecting method: %s into class %s", toAdd.methodName, this.className);
            }
        }
        super.visitEnd();
    }

    private int opcodeForReturnOfType(Type t) {
        if (t.equals((Object)Type.VOID_TYPE)) {
            return 177;
        }
        return t.getOpcode(172);
    }

    private void injectCallback(MethodVisitor mv, Lifecycle lifecycle) {
        Type[] originalArguments = Type.getArgumentTypes((String)lifecycle.methodDesc);
        Type[] arguments = new Type[originalArguments.length + 1];
        int argi = 0;
        arguments[argi++] = Type.getObjectType((String)this.rootClassName);
        for (Type t : originalArguments) {
            arguments[argi++] = t;
        }
        String methodDescription = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])arguments);
        mv.visitVarInsn(25, 0);
        for (int i = 0; i < originalArguments.length; ++i) {
            mv.visitVarInsn(25, i + 1);
        }
        mv.visitMethodInsn(184, "com/appdynamics/eumagent/runtime/InstrumentationCallbacks", lifecycle.instrumentationMethodName, methodDescription, false);
        this.logInjectedWithOnlySourceInfo("Finished injecting call to %s.%s at %s.%s", "com/appdynamics/eumagent/runtime/InstrumentationCallbacks", lifecycle.instrumentationMethodName, this.className, lifecycle.methodName);
    }

    private Set<Lifecycle> getMethodsNotImplemented() {
        HashSet<Lifecycle> methodsNotImplemented = new HashSet<Lifecycle>();
        methodsNotImplemented.addAll(this.lifecycleMap.values());
        methodsNotImplemented.removeAll(this.methodPresent);
        return methodsNotImplemented;
    }

    public static class Lifecycle {
        public final int access;
        public final String methodName;
        public final String methodDesc;
        public final String instrumentationMethodName;

        public Lifecycle(int access, String methodName, String methodDesc) {
            this.access = access;
            this.methodName = methodName;
            this.methodDesc = methodDesc;
            this.instrumentationMethodName = methodName + "Called";
        }
    }

    private class LifecycleMethodVisitor
    extends BaseClassVisitor.BaseMethodVisitor {
        final Lifecycle lifecycle;

        public LifecycleMethodVisitor(int access, String name, MethodVisitor methodVisitor, String desc, Lifecycle lifecycle) {
            super(methodVisitor, access, name, desc);
            this.lifecycle = lifecycle;
        }

        public void visitCode() {
            this.mv.visitCode();
            LifecycleCallbacksInjector.this.injectCallback(this.mv, this.lifecycle);
        }
    }
}

