/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.android.bci.bytecodeinjectors;

import com.appdynamics.android.bci.bytecodeinjectors.BaseClassVisitor;
import com.appdynamics.android.bci.bytecodeinjectors.config.MethodDefinitionMatcher;
import com.appdynamics.android.logging.BCIRunSummary;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.Method;

public class WrapMethodCodeInjector
extends BaseClassVisitor {
    private final String feature;
    private final MethodDefinitionMatcher methodDefinitionMatcher;
    private final Method enterMethod;
    private final Method exitMethod;
    private final Method threwMethod;
    private final String exceptionClass;
    private boolean ignoreArgs;
    private boolean isTargetClass = false;

    public WrapMethodCodeInjector(String feature, ClassVisitor cv, MethodDefinitionMatcher methodDefinitionMatcher, Method enterMethod, Method exitMethod, Method threwMethod, String exceptionClass, boolean ignoreArgs) {
        super(cv);
        this.feature = feature;
        this.methodDefinitionMatcher = methodDefinitionMatcher;
        this.enterMethod = enterMethod;
        this.exitMethod = exitMethod;
        this.threwMethod = threwMethod;
        this.exceptionClass = exceptionClass;
        this.ignoreArgs = ignoreArgs;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.isTargetClass = this.methodDefinitionMatcher.matchesClass(name);
    }

    public MethodVisitor visitMethod(int access, String methodName, String methodDesc, String signature, String[] exceptions) {
        boolean isTargetMethod;
        MethodVisitor baseMV = super.visitMethod(access, methodName, methodDesc, signature, exceptions);
        if (this.isTargetClass && (isTargetMethod = this.methodDefinitionMatcher.matchesMethod(methodName, methodDesc))) {
            return new WrapMethodCodeMethodVisitor(baseMV, access, methodName, methodDesc);
        }
        return baseMV;
    }

    private class WrapMethodCodeMethodVisitor
    extends BaseClassVisitor.BaseMethodVisitor {
        private final Label tryStartLabel;
        private final Label tryEndLabel;
        private Method thisMethod;

        WrapMethodCodeMethodVisitor(MethodVisitor mv, int access, String methodName, String methodDesc) {
            super(mv, access, methodName, methodDesc);
            this.tryStartLabel = new Label();
            this.tryEndLabel = new Label();
        }

        public void visitCode() {
            this.mv.visitCode();
            WrapMethodCodeInjector.this.logInjectedWithLineNumber("Instrumenting method: %s%s", this.methodName, this.methodDesc);
            BCIRunSummary.getDefaultInstance().featureInjected(WrapMethodCodeInjector.this.feature, WrapMethodCodeInjector.this.className);
            this.thisMethod = new Method(this.methodName, this.methodDesc);
            if (WrapMethodCodeInjector.this.threwMethod != null) {
                this.mv.visitLabel(this.tryStartLabel);
            }
            if (WrapMethodCodeInjector.this.enterMethod != null) {
                this.loadThis();
                if (!WrapMethodCodeInjector.this.ignoreArgs) {
                    this.loadArgs();
                }
                this.instrumentationCallback(WrapMethodCodeInjector.this.enterMethod);
            }
        }

        public void visitInsn(int opcode) {
            if (WrapMethodCodeInjector.this.exitMethod != null) {
                if (opcode == 177) {
                    this.loadThis();
                    this.instrumentationCallback(WrapMethodCodeInjector.this.exitMethod);
                } else if (opcode == 172 || opcode == 175 || opcode == 174 || opcode == 176) {
                    int resultLocal = this.storeTopOfStack(this.thisMethod.getReturnType());
                    this.loadThis();
                    this.loadLocal(resultLocal, this.thisMethod.getReturnType());
                    this.instrumentationCallback(WrapMethodCodeInjector.this.exitMethod);
                    this.loadLocal(resultLocal, this.thisMethod.getReturnType());
                }
            }
            this.mv.visitInsn(opcode);
        }

        public void visitMaxs(int maxStack, int maxLocals) {
            if (WrapMethodCodeInjector.this.threwMethod != null) {
                this.mv.visitLabel(this.tryEndLabel);
                super.visitInsn(89);
                this.loadThis();
                super.visitInsn(95);
                this.instrumentationCallback(WrapMethodCodeInjector.this.threwMethod);
                this.mv.visitInsn(191);
            }
            this.mv.visitMaxs(maxStack, maxLocals);
        }

        @Override
        public void visitEnd() {
            if (WrapMethodCodeInjector.this.threwMethod != null) {
                this.mv.visitTryCatchBlock(this.tryStartLabel, this.tryEndLabel, this.tryEndLabel, WrapMethodCodeInjector.this.exceptionClass);
            }
            super.visitEnd();
        }
    }
}

