/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.android.bci.bytecodeinjectors;

import com.appdynamics.android.bci.classinjectors.RuntimeCallbackInjector;
import com.appdynamics.android.logging.BCILogger;
import com.appdynamics.android.logging.BCIRunSummary;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.ListIterator;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.AdviceAdapter;

public class GenericInjector
extends ClassVisitor
implements Opcodes {
    protected final BCILogger logger = BCILogger.getLoggerFor(((Object)((Object)this)).getClass());
    private final ClassVisitor cv;
    private final ClassInfo ci;
    private final RuntimeCallbackInjector callbackInjector;

    public GenericInjector(ClassInfo classInfo, ClassVisitor cv, RuntimeCallbackInjector callbackInjector) {
        super(458752, cv);
        this.cv = cv;
        this.ci = new ClassInfo(classInfo);
        this.callbackInjector = callbackInjector;
    }

    private String instrumentingClass() {
        return this.ci.path + "$" + this.ci.instrumentedBy;
    }

    private static String opaquify(Type[] types) {
        StringBuilder sb = new StringBuilder();
        for (Type t : types) {
            if (t.getSort() == 10) {
                sb.append("Ljava/lang/Object;");
                continue;
            }
            sb.append(t.getDescriptor());
        }
        return sb.toString();
    }

    private static String enterSignature(String sig) {
        return "(Ljava/lang/Object;" + GenericInjector.opaquify(Type.getArgumentTypes((String)sig)) + ")Ljava/lang/Object;";
    }

    private static String replaceSignature(String sig) {
        return "(" + "Ljava/lang/Object;" + GenericInjector.opaquify(Type.getArgumentTypes((String)sig)) + ")" + GenericInjector.opaquify(new Type[]{Type.getReturnType((String)sig)});
    }

    private static String exitSignature(String sig) {
        return "(" + "Ljava/lang/Object;" + "Ljava/lang/Object;" + "Ljava/lang/Object;" + GenericInjector.opaquify(Type.getArgumentTypes((String)sig)) + ")V";
    }

    private static String wrapLastArgSignature(String sig) {
        Type[] types = Type.getArgumentTypes((String)sig);
        if (types.length == 0) {
            throw new RuntimeException("Cannot wrap last arg when there are no args");
        }
        String lastArgDescriptor = types[types.length - 1].getDescriptor();
        return "(" + lastArgDescriptor + ")" + lastArgDescriptor;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor methodVisitor = this.cv.visitMethod(access, name, desc, signature, exceptions);
        if (methodVisitor == null) {
            return null;
        }
        return new GenericMethodVisitor(methodVisitor, access, name, desc);
    }

    public static class ClassInfo {
        private final String path;
        private final String instrumentedBy;
        private final String clazz;
        private final String method;
        private final String signature;
        private final String exceptionToCatch;
        private final EnumSet<InstrumentationTypes> instrumentation;
        private final String feature;
        private final List<String> classesToInject;

        static String checkForNull(String parm, String s) {
            if (s == null) {
                throw new NullPointerException(parm + " cannot be null");
            }
            return s;
        }

        private ClassInfo(Builder builder) {
            this.path = ClassInfo.checkForNull("path", builder.path);
            this.instrumentedBy = ClassInfo.checkForNull("instrumentedBy", builder.instrumentedBy);
            this.clazz = ClassInfo.checkForNull("owner", builder.owner);
            this.method = ClassInfo.checkForNull("builder", builder.method);
            this.signature = ClassInfo.checkForNull("signature", builder.signature);
            this.exceptionToCatch = builder.exceptionToCatch;
            this.instrumentation = builder.instrumentation;
            this.feature = builder.feature;
            this.classesToInject = builder.classesToInject;
        }

        public ClassInfo(ClassInfo ci) {
            this.path = ci.path;
            this.instrumentedBy = ci.instrumentedBy;
            this.clazz = ci.clazz;
            this.method = ci.method;
            this.signature = ci.signature;
            this.exceptionToCatch = ci.exceptionToCatch;
            this.instrumentation = ci.instrumentation;
            this.feature = ci.feature;
            this.classesToInject = ci.classesToInject;
        }

        public static class Builder {
            private String path;
            private String instrumentedBy;
            private String owner;
            private String method;
            private String signature;
            private String exceptionToCatch;
            private EnumSet<InstrumentationTypes> instrumentation;
            private String feature;
            private List<String> classesToInject;

            public Builder() {
                this.exceptionToCatch(null);
                this.instrumentation = EnumSet.noneOf(InstrumentationTypes.class);
            }

            public Builder path(String path) {
                this.path = path;
                return this;
            }

            public Builder instrumentedBy(String instrumentedBy) {
                if ("<init>".equals(instrumentedBy)) {
                    instrumentedBy = "INIT";
                }
                this.instrumentedBy = instrumentedBy;
                return this;
            }

            public Builder owner(String owner) {
                this.owner = owner;
                return this;
            }

            public Builder method(String method) {
                this.method = method;
                return this;
            }

            public Builder signature(String signature) {
                this.signature = signature;
                return this;
            }

            public Builder exceptionToCatch(String exceptionToCatch) {
                this.exceptionToCatch = exceptionToCatch;
                return this;
            }

            public Builder instrumentation(EnumSet<InstrumentationTypes> instrumentation) {
                this.instrumentation = instrumentation;
                return this;
            }

            public Builder feature(String feature) {
                this.feature = feature;
                return this;
            }

            public Builder classesToInject(List<String> classesToInject) {
                this.classesToInject = classesToInject;
                return this;
            }

            public ClassInfo build() {
                return new ClassInfo(this);
            }
        }
    }

    protected class GenericMethodVisitor
    extends AdviceAdapter {
        protected String methodName;
        private List<ExceptionHandler> exceptionHandlers;
        static final int NO_SCRATCH_OBJECT = -1;

        protected GenericMethodVisitor(MethodVisitor mv, int access, String name, String desc) {
            super(458752, mv, access, name, desc);
            this.exceptionHandlers = new ArrayList<ExceptionHandler>();
            this.methodName = name;
        }

        private void pushNULL() {
            super.visitInsn(1);
        }

        public void visitCode() {
            this.exceptionHandlers.clear();
            super.visitCode();
        }

        public void visitEnd() {
            for (ExceptionHandler handler : this.exceptionHandlers) {
                super.visitTryCatchBlock(handler.start, handler.end, handler.handler, handler.type);
            }
            super.visitEnd();
        }

        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
            this.exceptionHandlers.add(new ExceptionHandler(start, end, handler, type));
        }

        private void wrapPrimitive(String type, String sig) {
            String obj = "java/lang/" + type;
            super.visitTypeInsn(187, obj);
            super.visitInsn(92);
            super.visitInsn(95);
            super.visitMethodInsn(183, obj, "<init>", sig, false);
        }

        private void wrapTwoSlotPrimitive(String type, String sig) {
            String obj = "java/lang/" + type;
            super.visitInsn(92);
            super.visitTypeInsn(187, obj);
            super.visitInsn(89);
            super.visitInsn(94);
            super.visitInsn(88);
            super.visitMethodInsn(183, obj, "<init>", sig, false);
        }

        private void wrapStackItemByType(Type type) {
            switch (type.getSort()) {
                case 0: {
                    this.pushNULL();
                    break;
                }
                case 1: {
                    this.wrapPrimitive("Boolean", "(Z)V");
                    break;
                }
                case 2: {
                    this.wrapPrimitive("Character", "(C)V");
                    break;
                }
                case 3: {
                    this.wrapPrimitive("Byte", "(B)V");
                    break;
                }
                case 4: {
                    this.wrapPrimitive("Short", "(S)V");
                    break;
                }
                case 5: {
                    this.wrapPrimitive("Integer", "(I)V");
                    break;
                }
                case 6: {
                    this.wrapPrimitive("Float", "(F)V");
                    break;
                }
                case 7: {
                    this.wrapTwoSlotPrimitive("Long", "(J)V");
                    break;
                }
                case 8: {
                    this.wrapTwoSlotPrimitive("Double", "(D)V");
                    break;
                }
                default: {
                    super.visitInsn(89);
                }
            }
        }

        private int instrumentEntry(int objectRefLocal, ArgStore args, String desc, String instrumentingOwner) {
            if (!GenericInjector.this.ci.instrumentation.contains((Object)InstrumentationTypes.Entry)) {
                return -1;
            }
            this.loadLocal(objectRefLocal);
            args.pushArgs();
            String sig = GenericInjector.enterSignature(desc);
            super.visitMethodInsn(184, instrumentingOwner, "Enter", sig, false);
            GenericInjector.this.logger.debug("  Enter: " + sig, new Object[0]);
            int scratchRefLocal = this.newLocal(Type.getReturnType((String)sig));
            this.storeLocal(scratchRefLocal);
            return scratchRefLocal;
        }

        private void instrumentWrapLastArg(String desc, String instrumentingOwner) {
            if (!GenericInjector.this.ci.instrumentation.contains((Object)InstrumentationTypes.WrapLastArg)) {
                return;
            }
            String sig = GenericInjector.wrapLastArgSignature(desc);
            GenericInjector.this.logger.debug("  WrapLastArg: %s", sig);
            super.visitMethodInsn(184, instrumentingOwner, "WrapLastArg", sig, false);
        }

        private void instrumentReplace(int objectRefLocal, ArgStore args, String instrumentingOwner, int opcode, String owner, String name, String desc, boolean itf) {
            if (GenericInjector.this.ci.instrumentation.contains((Object)InstrumentationTypes.Replace)) {
                this.loadLocal(objectRefLocal);
                args.pushArgs();
                String sig = GenericInjector.replaceSignature(desc);
                GenericInjector.this.logger.debug("  Replace: " + sig, new Object[0]);
                super.visitMethodInsn(184, instrumentingOwner, "Replace", sig, false);
            } else {
                if (opcode != 184) {
                    this.loadLocal(objectRefLocal);
                }
                args.pushArgs();
                super.visitMethodInsn(opcode, owner, name, desc, itf);
            }
        }

        private void instrumentExit(int objectRefLocal, int scratchRefLocal, ArgStore args, String instrumentingOwner, String desc) {
            if (!GenericInjector.this.ci.instrumentation.contains((Object)InstrumentationTypes.Exit)) {
                return;
            }
            this.wrapStackItemByType(Type.getReturnType((String)desc));
            this.loadLocal(objectRefLocal);
            super.visitInsn(95);
            if (scratchRefLocal != -1) {
                this.loadLocal(scratchRefLocal);
            } else {
                this.pushNULL();
            }
            args.pushArgs();
            String sig = GenericInjector.exitSignature(desc);
            super.visitMethodInsn(184, instrumentingOwner, "Exit", sig, false);
            GenericInjector.this.logger.debug("  Exit: " + sig, new Object[0]);
        }

        private void instrumentThrowMe(int objectRefLocal, int scratchRefLocal, String instrumentingOwner, Label startCatchLabel) {
            if (GenericInjector.this.ci.exceptionToCatch == null) {
                return;
            }
            Label endCatchLabel = new Label();
            super.visitJumpInsn(167, endCatchLabel);
            super.visitLabel(startCatchLabel);
            super.visitInsn(89);
            this.loadLocal(objectRefLocal);
            super.visitInsn(95);
            if (scratchRefLocal != -1) {
                this.loadLocal(scratchRefLocal);
            } else {
                this.pushNULL();
            }
            super.visitInsn(95);
            String sig = "(Ljava/lang/Object;Ljava/lang/Object;L" + GenericInjector.this.ci.exceptionToCatch + ";)V";
            super.visitMethodInsn(184, instrumentingOwner, "ThrowMe", sig, false);
            super.visitInsn(191);
            super.visitLabel(endCatchLabel);
            GenericInjector.this.logger.debug("  ThrowMe: " + sig, new Object[0]);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            if (!(opcode >= 182 && opcode <= 186 && GenericInjector.this.ci.clazz.equals(owner) && GenericInjector.this.ci.method.equals(name) && GenericInjector.this.ci.signature.equals(desc))) {
                super.visitMethodInsn(opcode, owner, name, desc, itf);
                return;
            }
            if (GenericInjector.this.ci.classesToInject != null) {
                for (String classToInject : GenericInjector.this.ci.classesToInject) {
                    GenericInjector.this.callbackInjector.addClassToInject(classToInject);
                }
            }
            BCIRunSummary.getDefaultInstance().featureInjected(GenericInjector.this.ci.feature, name);
            String instrumentingOwner = GenericInjector.this.instrumentingClass();
            GenericInjector.this.logger.debug(instrumentingOwner + " {", new Object[0]);
            if (GenericInjector.this.ci.instrumentation.contains((Object)InstrumentationTypes.Entry) || GenericInjector.this.ci.instrumentation.contains((Object)InstrumentationTypes.Exit) || GenericInjector.this.ci.instrumentation.contains((Object)InstrumentationTypes.Replace)) {
                ArgStore args = new ArgStore(desc);
                args.popArgs();
                int objectRefLocal = this.newLocal(Type.getObjectType((String)owner));
                if (opcode != 184) {
                    this.storeLocal(objectRefLocal);
                } else {
                    this.pushNULL();
                    this.storeLocal(objectRefLocal);
                }
                int scratchRefLocal = this.instrumentEntry(objectRefLocal, args, desc, instrumentingOwner);
                Label startCatchLabel = new Label();
                if (GenericInjector.this.ci.exceptionToCatch != null) {
                    Label startTryLabel = new Label();
                    super.visitTryCatchBlock(startTryLabel, startCatchLabel, startCatchLabel, GenericInjector.this.ci.exceptionToCatch);
                    super.visitLabel(startTryLabel);
                }
                this.instrumentWrapLastArg(desc, instrumentingOwner);
                this.instrumentReplace(objectRefLocal, args, instrumentingOwner, opcode, owner, name, desc, itf);
                this.instrumentExit(objectRefLocal, scratchRefLocal, args, instrumentingOwner, desc);
                this.instrumentThrowMe(objectRefLocal, scratchRefLocal, instrumentingOwner, startCatchLabel);
                GenericInjector.this.logger.debug("}", new Object[0]);
            } else {
                this.instrumentWrapLastArg(desc, instrumentingOwner);
                super.visitMethodInsn(opcode, owner, name, desc, itf);
            }
        }

        private class ArgStore {
            final ArrayList<SavedArgument> args = new ArrayList();

            protected ArgStore(String desc) {
                Type[] argTypes = Type.getArgumentTypes((String)desc);
                for (int i = argTypes.length - 1; i >= 0; --i) {
                    this.args.add(new SavedArgument(argTypes[i], GenericMethodVisitor.this.newLocal(argTypes[i])));
                }
            }

            protected void popArgs() {
                for (SavedArgument arg : this.args) {
                    GenericMethodVisitor.this.storeLocal(arg.local, arg.type);
                }
            }

            protected void pushArgs() {
                ListIterator<SavedArgument> li = this.args.listIterator(this.args.size());
                while (li.hasPrevious()) {
                    SavedArgument arg = li.previous();
                    GenericMethodVisitor.this.loadLocal(arg.local);
                }
            }
        }
    }

    private static class ExceptionHandler {
        private final Label start;
        private final Label end;
        private final Label handler;
        private final String type;

        private ExceptionHandler(Label start, Label end, Label handler, String type) {
            this.start = start;
            this.end = end;
            this.handler = handler;
            this.type = type;
        }
    }

    private static class SavedArgument {
        final Type type;
        final int local;

        SavedArgument(Type type, int local) {
            this.type = type;
            this.local = local;
        }
    }

    public static enum InstrumentationTypes {
        Entry,
        Exit,
        Replace,
        WrapLastArg;

    }
}

