/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.android.logging;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public abstract class BCILogger {
    private static BCILogger bciLogger;

    public static void setBciLogger(BCILogger logger) {
        if (logger == null) {
            throw new IllegalArgumentException("BCILogger cannot be null!");
        }
        if (bciLogger != null) {
            throw new IllegalStateException("BCILogger already set to: " + logger);
        }
        bciLogger = logger;
    }

    public static boolean isInitialized() {
        return bciLogger != null;
    }

    public static BCILogger getBciLogger() {
        if (bciLogger == null) {
            throw new IllegalStateException("BCILogger isn't initialized yet!");
        }
        return bciLogger;
    }

    public static BCILogger getLoggerFor(final Class<?> clazz) {
        return new BCILogger(){

            @Override
            protected void log(Level level, String msg) {
                BCILogger.getBciLogger().log(level, " <" + clazz.getSimpleName() + "> " + msg);
            }

            @Override
            public void error(Throwable th, String msg) {
                BCILogger.getBciLogger().error(th, " <" + clazz.getSimpleName() + "> " + msg);
            }
        };
    }

    private void log(Level level, String msg, Object ... args) {
        if (args == null || args.length == 0) {
            this.log(level, msg);
        } else {
            this.log(level, String.format(msg, args));
        }
    }

    public void error(Throwable th, String msg, Object ... args) {
        if (args == null || args.length == 0) {
            this.error(th, msg);
        } else {
            this.error(th, String.format(msg, args));
        }
    }

    protected abstract void log(Level var1, String var2);

    public abstract void error(Throwable var1, String var2);

    public void trace(String msg, Object ... args) {
        this.log(Level.TRACE, msg, args);
    }

    public void debug(String msg, Object ... args) {
        this.log(Level.DEBUG, msg, args);
    }

    public void info(String msg, Object ... args) {
        this.log(Level.INFO, msg, args);
    }

    public void warn(String msg, Object ... args) {
        this.log(Level.WARN, msg, args);
    }

    public void error(String msg, Object ... args) {
        this.log(Level.ERROR, msg, args);
    }

    public static enum Level {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }

    public static abstract class MultiLogger
    extends BCILogger {
        private final File logFile;
        private boolean hasLoggedError = false;

        protected MultiLogger(File logDir) {
            if (logDir == null || !logDir.isDirectory()) {
                throw new IllegalArgumentException("logFile: [" + logDir + "] cannot be null. Need a valid directory!");
            }
            this.logFile = new File(logDir, "appdynamics_eum_android_bci.log");
            this.logFile.delete();
        }

        protected abstract void _log(Level var1, String var2);

        @Override
        public final synchronized void log(Level level, String msg) {
            block2: {
                this._log(level, msg);
                try {
                    FileOutputStream outputStream = new FileOutputStream(this.logFile, true);
                    ((OutputStream)outputStream).write(msg.getBytes());
                    ((OutputStream)outputStream).write("\n".getBytes());
                    ((OutputStream)outputStream).close();
                }
                catch (IOException e) {
                    if (this.hasLoggedError) break block2;
                    this._log(Level.ERROR, "Unable to write to logFile [" + this.logFile.getAbsolutePath() + "] because of: " + e);
                    this.hasLoggedError = true;
                }
            }
        }

        @Override
        public final synchronized void error(Throwable th, String msg) {
            try {
                FileOutputStream outputStream = new FileOutputStream(this.logFile, true);
                PrintStream printStream = new PrintStream(outputStream, false);
                printStream.append("[ERROR] " + msg);
                th.printStackTrace(printStream);
                printStream.append("\n");
                printStream.close();
                ((OutputStream)outputStream).close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

