/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.android.bci.bytecodeinjectors;

import com.appdynamics.android.bci.bytecodeinjectors.BaseClassVisitor;
import com.appdynamics.android.bci.bytecodeinjectors.config.MethodCallMatcher;
import com.appdynamics.android.logging.BCIRunSummary;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.Method;

public class ReplaceComposeNavigationMethod
extends BaseClassVisitor {
    public static final String APPDYNAMICS_NAVIGATION_OBSERVER_KT_CLASS = "com/appdynamics/compose/AppdynamicsNavigationObserverKt";
    private final MethodCallMatcher methodCallMatcher;
    private final Method replaceMethod;
    private final String featureName;

    public ReplaceComposeNavigationMethod(ClassVisitor delegate, MethodCallMatcher methodCallMatcher1, Method replaceMethod1, String featureName1) {
        super(delegate);
        this.methodCallMatcher = methodCallMatcher1;
        this.replaceMethod = replaceMethod1;
        this.featureName = featureName1;
    }

    public MethodVisitor visitMethod(int access, String methodName, String methodDesc, String signature, String[] exceptions) {
        MethodVisitor baseMV = super.visitMethod(access, methodName, methodDesc, signature, exceptions);
        return new ReplaceMethodCallMethodVisitor(baseMV, access, methodName, methodDesc);
    }

    private class ReplaceMethodCallMethodVisitor
    extends BaseClassVisitor.BaseMethodVisitor {
        private boolean afterRememberCall;
        private int storeSlot;

        ReplaceMethodCallMethodVisitor(MethodVisitor mv, int access, String methodName, String methodDesc) {
            super(mv, access, methodName, methodDesc);
            this.afterRememberCall = false;
            this.storeSlot = -1;
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            if (this.isMatchMethod(opcode, owner, name, desc, itf)) {
                BCIRunSummary.getDefaultInstance().featureInjected(ReplaceComposeNavigationMethod.this.featureName, ReplaceComposeNavigationMethod.this.className);
                ReplaceComposeNavigationMethod.this.logInjectedWithLineNumber("Instrumenting method: %s%s", this.methodName, this.methodDesc);
                super.visitMethodInsn(184, ReplaceComposeNavigationMethod.APPDYNAMICS_NAVIGATION_OBSERVER_KT_CLASS, ReplaceComposeNavigationMethod.this.replaceMethod.getName(), ReplaceComposeNavigationMethod.this.replaceMethod.getDescriptor(), false);
            } else {
                super.visitMethodInsn(opcode, owner, name, desc, itf);
            }
        }

        public void visitInsn(int opcode) {
            if (this.afterRememberCall) {
                if (opcode == 176) {
                    this.mv.visitVarInsn(25, this.storeSlot);
                } else {
                    this.mv.visitInsn(87);
                }
                this.afterRememberCall = false;
            }
            super.visitInsn(opcode);
        }

        public void visitVarInsn(int opcode, int varIndex) {
            if (this.afterRememberCall) {
                if (opcode == 58) {
                    this.mv.visitVarInsn(25, this.storeSlot);
                } else {
                    this.mv.visitInsn(87);
                }
                this.afterRememberCall = false;
            }
            super.visitVarInsn(opcode, varIndex);
        }

        boolean isMatchMethod(int opCode, String owner, String name, String desc, boolean itf) {
            for (int i = 0; i < ReplaceComposeNavigationMethod.this.methodCallMatcher.targetMethods.length; ++i) {
                Method targetMethod = ReplaceComposeNavigationMethod.this.methodCallMatcher.targetMethods[i];
                if (!owner.equals(ReplaceComposeNavigationMethod.this.methodCallMatcher.targetClass) || opCode != 184 || !name.equals(targetMethod.getName()) || !desc.equals(targetMethod.getDescriptor())) continue;
                return true;
            }
            return false;
        }
    }
}

