/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.android.bci;

import com.appdynamics.android.logging.BCILogger;
import com.appdynamics.android.logging.BCIRunSummary;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.AdviceAdapter;

public class BaseClassVisitor
extends ClassVisitor
implements Opcodes {
    public static final String CALLBACK_CLASS_JVMSTYLE = "com/appdynamics/eumagent/runtime/InstrumentationCallbacks";
    public static final Type CALLBACK_CLASS_TYPE = Type.getType("com/appdynamics/eumagent/runtime/InstrumentationCallbacks");
    protected final BCILogger logger = BCILogger.getLoggerFor(this.getClass());
    public static final String HTTP_URLCLASS_JVMSTYLE = "java/net/HttpURLConnection";
    public static final String HTTPS_URLCLASS_JVMSTYLE = "javax/net/ssl/HttpsURLConnection";
    protected int lineNumber = -1;
    protected String className;
    protected String sourceName = null;

    public BaseClassVisitor(ClassVisitor cv) {
        super(262144, cv);
    }

    @Override
    public void visitSource(String source, String debug) {
        super.visitSource(source, debug);
        if (source != null && source.length() > 0) {
            this.sourceName = source;
        }
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.className = name.replace("/", ".");
    }

    protected BCIRunSummary.Feature toNetworkFeature(String owner) {
        return HTTP_URLCLASS_JVMSTYLE.equals(owner) || HTTPS_URLCLASS_JVMSTYLE.equals(owner) ? BCIRunSummary.Feature.URL_HTTP : BCIRunSummary.Feature.APACHE_HTTP;
    }

    protected void reportNetworkFeatureInjected(String owner) {
        BCIRunSummary.getDefaultInstance().featureInjected(this.toNetworkFeature(owner), this.className);
    }

    protected void logInjectedWithLineNumber(String msg, Object ... args) {
        this.logInjected(true, msg, args);
    }

    private void logInjected(boolean includeLineNo, String msg, Object ... args) {
        StringBuilder appendWith = new StringBuilder();
        if (this.sourceName != null) {
            appendWith.append(" @ (").append(this.sourceName);
        }
        if (includeLineNo && this.lineNumber != -1) {
            appendWith.append(":").append(this.lineNumber);
        }
        if (appendWith.length() > 0) {
            appendWith.append(")");
        }
        if (appendWith.length() > 0) {
            this.logger.debug(msg + appendWith, args);
        } else {
            this.logger.debug(msg, args);
        }
    }

    protected void logInjectedWithOnlySourceInfo(String msg, Object ... args) {
        this.logInjected(false, msg, args);
    }

    public String getClassName() {
        return this.className;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    protected class BaseMethodVisitor
    extends AdviceAdapter {
        protected String methodName;

        protected BaseMethodVisitor(MethodVisitor mv, int access, String name, String desc) {
            super(262144, mv, access, name, desc);
            this.methodName = name;
        }

        @Override
        public void visitLineNumber(int line, Label start) {
            super.visitLineNumber(line, start);
            if (line > BaseClassVisitor.this.lineNumber) {
                BaseClassVisitor.this.lineNumber = line;
            }
        }

        @Override
        public void visitEnd() {
            super.visitEnd();
        }
    }
}

