/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.android.bci.infop;

import com.appdynamics.android.bci.BCILifecycleListener;
import com.appdynamics.android.bci.BaseClassVisitor;
import com.appdynamics.android.bci.ClassUtil;
import com.appdynamics.android.bci.IAdapterFactory;
import com.appdynamics.android.bci.infop.MasterFlagGenerator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

public class ConstructorInvokeReplacer
extends BCILifecycleListener.Adapter
implements IAdapterFactory,
Opcodes {
    private final MasterFlagGenerator generator = new MasterFlagGenerator();
    private final ClassUtil classUtil;
    private boolean enabled = false;
    private static final Set<String> EXCLUDED_PACKAGES = new HashSet<String>(Arrays.asList("android/", "java/", "javax/", "junit/", "org/apache", "org/json", "org/w3c", "org/xml", "com/appdynamics"));

    public ConstructorInvokeReplacer(ClassUtil classUtil) {
        this.classUtil = classUtil;
    }

    @Override
    public ClassVisitor createAdapter(ClassVisitor delegate) {
        return new Visitor(delegate);
    }

    private boolean isIncluded(String type) {
        for (String excluded : EXCLUDED_PACKAGES) {
            if (!type.startsWith(excluded)) continue;
            return false;
        }
        return true;
    }

    MasterFlagGenerator getGenerator() {
        return this.generator;
    }

    public void writeMasterFlagsClassInto(File outputFile) throws IOException {
        this.generator.writeMasterFlagsClassInto(outputFile);
    }

    @Override
    public void endInstrumentation(File classesDirectory) throws IOException {
        super.endInstrumentation(classesDirectory);
        this.writeMasterFlagsClassInto(classesDirectory);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    private class Visitor
    extends BaseClassVisitor {
        private final Stack<String> newObjects;

        public Visitor(ClassVisitor cv) {
            super(cv);
            this.newObjects = new Stack();
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
            if (!ConstructorInvokeReplacer.this.isEnabled()) {
                return mv;
            }
            return new BaseClassVisitor.BaseMethodVisitor(mv, access, name, desc){

                @Override
                public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                    if (opcode == 183 && "<init>".equals(name) && !Visitor.this.newObjects.isEmpty() && owner.equals(Visitor.this.newObjects.peek())) {
                        String type = (String)Visitor.this.newObjects.pop();
                        if (!ConstructorInvokeReplacer.this.generator.presentInInterceptedList(type) && this.isInterceptable(type, desc)) {
                            ConstructorInvokeReplacer.this.generator.addToInterceptedList(type);
                        }
                    }
                    super.visitMethodInsn(opcode, owner, name, desc);
                }

                private boolean isInterceptable(String type, String constructorArgs) {
                    ArrayList<String> args = new ArrayList<String>();
                    for (Type arg : Type.getArgumentTypes(constructorArgs)) {
                        args.add(arg.getClassName());
                    }
                    String className = Type.getObjectType(type).getClassName();
                    try {
                        ClassUtil.ConstructorInfo info = ConstructorInvokeReplacer.this.classUtil.getInformationAboutClass(className, args);
                        return !info.finalOrAnonymous() && info.isClassAndConstructorPublic() && info.ifNestedIsClassStatic();
                    }
                    catch (Exception e) {
                        Visitor.this.logger.error(e, "Error while processing class: %s, constructor = %s", className, constructorArgs);
                        return false;
                    }
                }

                @Override
                public void visitTypeInsn(int opcode, String type) {
                    if (opcode == 187 && ConstructorInvokeReplacer.this.isIncluded(type)) {
                        Visitor.this.newObjects.push(type);
                    }
                    super.visitTypeInsn(opcode, type);
                }
            };
        }
    }
}

