/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.android.bci.util;

import com.appdynamics.android.bci.ClassUtil;
import com.appdynamics.android.bci.util.ClassInfo;
import com.appdynamics.android.bci.util.TypeHierarchy;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;

public class DefaultClassUtil
implements ClassUtil {
    private final URLClassLoader classLoader;
    private final TypeHierarchy classHierarchy;

    public DefaultClassUtil(URL[] urls) {
        this.classLoader = new URLClassLoader(urls, ClassLoader.getSystemClassLoader().getParent());
        this.classHierarchy = new TypeHierarchy(this.classLoader);
    }

    @Override
    public String getCommonSuperClass(String type1, String type2) {
        try {
            ClassInfo c = this.classHierarchy.getClassInfo(type1);
            ClassInfo d = this.classHierarchy.getClassInfo(type2);
            return c.getCommonSuperClass(d).toBytecodeStyle();
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public ClassUtil.ConstructorInfo getInformationAboutClass(String type, List<String> constructorArgTypes) throws ClassNotFoundException, NoSuchMethodException {
        Class<?> mainClazz = Class.forName(type, false, this.classLoader);
        Class[] argTypes = new Class[constructorArgTypes.size()];
        for (int i = 0; i < argTypes.length; ++i) {
            String clazz = constructorArgTypes.get(i);
            argTypes[i] = "int".equals(clazz) ? Integer.TYPE : ("double".equals(clazz) ? Double.TYPE : ("long".equals(clazz) ? Long.TYPE : ("float".equals(clazz) ? Float.TYPE : ("byte".equals(clazz) ? Byte.TYPE : ("short".equals(clazz) ? Short.TYPE : ("boolean".equals(clazz) ? Boolean.TYPE : ("char".equals(clazz) ? Character.TYPE : Class.forName(constructorArgTypes.get(i), false, this.classLoader))))))));
        }
        Constructor<?> constructor = mainClazz.getDeclaredConstructor(argTypes);
        return new ClassUtil.ConstructorInfo(mainClazz.getModifiers(), constructor.getModifiers(), mainClazz.getEnclosingClass() != null || mainClazz.getEnclosingConstructor() != null || mainClazz.getEnclosingMethod() != null, mainClazz.isAnonymousClass());
    }
}

