/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.android.logging;

import com.appdynamics.android.bci.BCILifecycleListener;
import com.appdynamics.android.logging.BCILogger;
import com.appdynamics.android.util.BuildUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class BCIRunSummary
extends BCILifecycleListener.Adapter {
    private int classCount;
    private final Set<String> failedClasses = new HashSet<String>();
    private final HashMap<Feature, Set<String>> featureClasses = new HashMap();
    private static final BCIRunSummary summary = new BCIRunSummary();

    public static BCIRunSummary getDefaultInstance() {
        return summary;
    }

    public void featureInjected(Feature f, String className) {
        Set<String> classes = this.featureClasses.get((Object)f);
        if (classes == null) {
            classes = new HashSet<String>();
            this.featureClasses.put(f, classes);
        }
        classes.add(className);
    }

    public void failedToInstrumentClass(String className) {
        this.failedClasses.add(className);
    }

    public void incrementClassCount() {
        ++this.classCount;
    }

    private int getTotalInstrumented() {
        HashSet<String> allClasses = new HashSet<String>();
        for (Set<String> classes : this.featureClasses.values()) {
            allClasses.addAll(classes);
        }
        return allClasses.size();
    }

    private boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.size() == 0;
    }

    public void printSummary() {
        BCILogger logger = BCILogger.getBciLogger();
        String header = "AppDynamics BCI Instrumentation summary";
        logger.info("\n\n\n\t\t\t\t%s", BuildUtils.encloseInBanner(header, '=').replaceAll("\n", "\n\t\t\t\t"));
        int totalFeatures = 0;
        for (Feature f : Feature.values()) {
            Set<String> values = this.featureClasses.get((Object)f);
            totalFeatures += this.isEmpty(values) ? 0 : 1;
        }
        StringBuilder summary = new StringBuilder();
        summary.append(String.format("\n\t\t - %-70s(#%-5d classes)", "Total number of classes visited", this.classCount));
        summary.append(String.format("\n\t\t - %-70s(#%-5d classes)", "Total number of classes instrumented", this.getTotalInstrumented()));
        summary.append(String.format("\n\t\t - %-70s(#%-5d classes)", "Total number of classes failed to instrument", this.failedClasses.size()));
        summary.append(String.format("\n\t\t - %-70s(#%d)", "Total number of features discovered", totalFeatures));
        if (totalFeatures > 0) {
            summary.append("\n\n\tThe following features were discovered in your application by Appdynamics:");
            for (Feature feature : Feature.values()) {
                Set<String> values = this.featureClasses.get((Object)feature);
                if (this.isEmpty(values)) continue;
                summary.append(String.format("\n\t\t - %-70s(#%-5d classes)", feature.description, values.size()));
            }
        } else {
            summary.append("\n\nNo features were discovered in your application!");
        }
        if (this.isEmpty((Collection)this.featureClasses.get((Object)Feature.APACHE_HTTP)) && this.isEmpty((Collection)this.featureClasses.get((Object)Feature.URL_HTTP))) {
            summary.append("\n\n\t\t").append(BuildUtils.encloseInBanner("Warning: We did not detect any network calls in your application").replaceAll("\n", "\n\t\t"));
        }
        logger.info(summary.append("\n").toString(), new Object[0]);
        for (Map.Entry<Feature, Set<String>> entry : this.featureClasses.entrySet()) {
            StringBuilder featureInfo = new StringBuilder(String.format("\n\tPrinting out all the classes in which [%s] feature was discovered.", new Object[]{entry.getKey()}));
            for (String clazz : entry.getValue()) {
                featureInfo.append("\n\t\t - ").append(clazz);
            }
            logger.debug(featureInfo.toString(), new Object[0]);
        }
        if (this.failedClasses.size() > 0) {
            StringBuilder featureInfo = new StringBuilder("\n\tWe failed to instrument the following classes:");
            for (String clazz : this.failedClasses) {
                featureInfo.append("\n\t - ").append(clazz);
            }
            logger.info(featureInfo.append("\n\n").toString(), new Object[0]);
        }
    }

    @Override
    public void beginInstrumentation() {
        super.beginInstrumentation();
        BuildUtils.printInstrumentationStarting();
    }

    @Override
    public void endInstrumentation(File classesDirectory) throws IOException {
        super.endInstrumentation(classesDirectory);
        BCIRunSummary.getDefaultInstance().printSummary();
    }

    public static enum Feature {
        APACHE_HTTP("Network calls using apache's HttpClient"),
        URL_HTTP("Network calls using java.net.HttpURLConnection"),
        ANR("Detect Application not responding"),
        INFO_POINT("Info points reported statically"),
        DYNAMIC_INFO_POINTS("Info points injected at runtime"),
        CRASH_REPORTING("Automatically report app crashes");

        private final String description;

        private Feature(String description) {
            this.description = description;
        }
    }
}

