/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.android.bci;

import com.appdynamics.android.bci.BaseClassVisitor;
import com.appdynamics.android.bci.QName;
import com.appdynamics.repackaged.asm.ClassVisitor;
import com.appdynamics.repackaged.asm.Label;
import com.appdynamics.repackaged.asm.MethodVisitor;
import com.appdynamics.repackaged.asm.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class TimeMethodAdapter
extends BaseClassVisitor {
    private final QName methodToTime;
    private final String exceptionToCatch;
    private final ClassVisitor classVisitor;

    public TimeMethodAdapter(QName methodToTime, String exceptionToCatch, ClassVisitor classVisitor) {
        super(classVisitor);
        this.methodToTime = methodToTime;
        this.exceptionToCatch = exceptionToCatch;
        this.classVisitor = classVisitor;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor methodVisitor = this.classVisitor.visitMethod(access, name, desc, signature, exceptions);
        if (methodVisitor != null) {
            methodVisitor = new BaseClassVisitor.BaseMethodVisitor(methodVisitor, access, name, desc){
                private List<ExceptionHandler> exceptionHandlers;
                {
                    this.exceptionHandlers = new ArrayList<ExceptionHandler>();
                }

                @Override
                public void visitCode() {
                    this.exceptionHandlers.clear();
                    super.visitCode();
                }

                @Override
                public void visitEnd() {
                    for (ExceptionHandler handler : this.exceptionHandlers) {
                        super.visitTryCatchBlock(handler.start, handler.end, handler.handler, handler.type);
                    }
                    super.visitEnd();
                }

                @Override
                public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
                    this.exceptionHandlers.add(new ExceptionHandler(start, end, handler, type));
                }

                @Override
                public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                    boolean shouldChange;
                    boolean bl = shouldChange = opcode == 182 && TimeMethodAdapter.this.methodToTime.equals(new QName(owner, name));
                    if (shouldChange) {
                        TimeMethodAdapter.this.reportNetworkFeatureInjected(owner);
                    }
                    ArrayList<SavedArgument> args = new ArrayList<SavedArgument>();
                    int objectRefLocal = -1;
                    Label startTryLabel = new Label();
                    Label startCatchLabel = new Label();
                    Label endCatchLabel = new Label();
                    if (shouldChange) {
                        Type[] argTypes = Type.getArgumentTypes(desc);
                        for (int i = argTypes.length - 1; i >= 0; --i) {
                            args.add(new SavedArgument(argTypes[i], this.newLocal(argTypes[i])));
                        }
                        for (SavedArgument arg : args) {
                            this.storeLocal(arg.local, arg.type);
                        }
                        objectRefLocal = this.newLocal(Type.getObjectType("Ljava/net/URLConnection"));
                        super.visitInsn(89);
                        this.storeLocal(objectRefLocal);
                        ListIterator li = args.listIterator(args.size());
                        while (li.hasPrevious()) {
                            SavedArgument arg;
                            arg = (SavedArgument)li.previous();
                            this.loadLocal(arg.local);
                        }
                        this.loadLocal(objectRefLocal);
                        super.visitMethodInsn(184, "com/appdynamics/eumagent/runtime/InstrumentationCallbacks", "requestAboutToBeSent", "(Ljava/net/URLConnection;)V");
                        TimeMethodAdapter.this.logInjectedWithLineNumber("Finished injecting %s.%s before %s.%s", "com/appdynamics/eumagent/runtime/InstrumentationCallbacks", "requestAboutToBeSent", owner, this.methodName);
                        if (TimeMethodAdapter.this.exceptionToCatch != null) {
                            super.visitTryCatchBlock(startTryLabel, startCatchLabel, startCatchLabel, TimeMethodAdapter.this.exceptionToCatch);
                            super.visitLabel(startTryLabel);
                        }
                    }
                    super.visitMethodInsn(opcode, owner, name, desc);
                    if (shouldChange) {
                        this.loadLocal(objectRefLocal);
                        super.visitMethodInsn(184, "com/appdynamics/eumagent/runtime/InstrumentationCallbacks", "requestSent", "(Ljava/net/URLConnection;)V");
                        TimeMethodAdapter.this.logInjectedWithLineNumber("Finished injecting %s.%s after %s.%s", "com/appdynamics/eumagent/runtime/InstrumentationCallbacks", "requestSent", owner, this.methodName);
                        if (TimeMethodAdapter.this.exceptionToCatch != null) {
                            super.visitJumpInsn(167, endCatchLabel);
                            super.visitLabel(startCatchLabel);
                            super.visitInsn(89);
                            this.loadLocal(objectRefLocal);
                            super.visitInsn(95);
                            super.visitMethodInsn(184, "com/appdynamics/eumagent/runtime/InstrumentationCallbacks", "networkError", "(Ljava/net/URLConnection;Ljava/io/IOException;)V");
                            super.visitInsn(191);
                            super.visitLabel(endCatchLabel);
                        }
                    }
                }
            };
        }
        return methodVisitor;
    }

    private static class ExceptionHandler {
        private final Label start;
        private final Label end;
        private final Label handler;
        private final String type;

        private ExceptionHandler(Label start, Label end, Label handler, String type) {
            this.start = start;
            this.end = end;
            this.handler = handler;
            this.type = type;
        }
    }

    private static class SavedArgument {
        final Type type;
        final int local;

        SavedArgument(Type type, int local) {
            this.type = type;
            this.local = local;
        }
    }
}

