/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.android.bci.infop;

import com.appdynamics.android.logging.BCIRunSummary;
import com.appdynamics.android.util.BuildUtils;
import com.appdynamics.repackaged.asm.ClassVisitor;
import com.appdynamics.repackaged.asm.ClassWriter;
import com.appdynamics.repackaged.asm.FieldVisitor;
import com.appdynamics.repackaged.asm.Label;
import com.appdynamics.repackaged.asm.Opcodes;
import com.appdynamics.repackaged.asm.Type;
import com.appdynamics.repackaged.asm.commons.GeneratorAdapter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.LinkedHashSet;
import java.util.Set;

public class MasterFlagGenerator
implements Opcodes {
    public static final String CLAZZ_NAME = "com/appdynamics/eumagent/runtime/InfoPointRegister";
    protected final Set<String> pendingClasses = new LinkedHashSet<String>();

    public void addToInterceptedList(String clazzName) {
        BCIRunSummary.getDefaultInstance().featureInjected("DYNAMIC_INFO_POINTS", clazzName);
        this.pendingClasses.add(clazzName);
    }

    public boolean presentInInterceptedList(String className) {
        return this.pendingClasses.contains(className);
    }

    private void generateMasterFlagClass(ClassVisitor classVisitor) {
        classVisitor.visit(49, 4113, CLAZZ_NAME, null, "java/lang/Object", null);
        classVisitor.visitSource("InfoPointRegister.java", null);
        classVisitor.visitAnnotation("Lcom/appdynamics/eumagent/runtime/DontObfuscate;", false).visitEnd();
        this.addDefaultConstructor(classVisitor);
        String descriptor = Type.getType(Boolean.TYPE).getDescriptor();
        for (String clazz : this.pendingClasses) {
            String fieldName = this.toFieldName(clazz);
            FieldVisitor fv = classVisitor.visitField(4105, fieldName, descriptor, null, null);
            fv.visitEnd();
        }
        classVisitor.visitEnd();
    }

    public byte[] writeMasterFlagsClassInto(File rootFolder) throws IOException {
        byte[] byArray;
        block5: {
            FileOutputStream out = null;
            try {
                ClassWriter writer = new ClassWriter(2);
                this.generateMasterFlagClass(writer);
                File file = new File(rootFolder.getAbsolutePath() + "/" + CLAZZ_NAME + ".class");
                file.getParentFile().mkdirs();
                out = new FileOutputStream(file);
                byte[] buffer = writer.toByteArray();
                out.write(buffer);
                byArray = buffer;
                if (out == null) break block5;
            }
            catch (Exception ex) {
                try {
                    throw new IOException(ex);
                }
                catch (Throwable throwable) {
                    if (out != null) {
                        BuildUtils.closeQuietly(out);
                    }
                    throw throwable;
                }
            }
            BuildUtils.closeQuietly(out);
        }
        return byArray;
    }

    private void addDefaultConstructor(ClassVisitor classVisitor) {
        Label startConstructorLabel = new Label();
        Label endConstructorLabel = new Label();
        GeneratorAdapter mv = new GeneratorAdapter(classVisitor.visitMethod(1, "<init>", "()V", null, null), 1, "<init>", "()V");
        mv.visitLabel(startConstructorLabel);
        mv.visitIntInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
        mv.getStatic(Type.getType(System.class), "out", Type.getType(PrintStream.class));
        mv.visitLdcInsn("Instantiating " + CLAZZ_NAME.replace("/", "."));
        mv.visitMethodInsn(182, "java/io/PrintStream", "println", "(Ljava/lang/String;)V");
        mv.visitInsn(177);
        mv.visitLabel(endConstructorLabel);
        mv.visitLocalVariable("this", "Lcom/appdynamics/eumagent/runtime/InfoPointRegister;", null, startConstructorLabel, endConstructorLabel, 0);
        mv.visitMaxs(2, 1);
        mv.visitEnd();
    }

    public String toFieldName(String clazzName) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < clazzName.length(); ++i) {
            char c = clazzName.charAt(i);
            if (Character.isJavaIdentifierPart(c)) {
                builder.append(c);
                continue;
            }
            builder.append("_");
        }
        return builder.toString();
    }
}

