/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.android.bci;

import com.appdynamics.android.bci.BCILifecycleListenerWrapper;
import com.appdynamics.android.bci.BuildIdGenerator;
import com.appdynamics.android.bci.OpaqueCallbackInjector;
import com.appdynamics.android.bci.infop.ConstructorInvokeReplacer;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;

public class BuildFinalizer
extends BCILifecycleListenerWrapper {
    private final ConstructorInvokeReplacer replacer;
    private final BuildIdGenerator buildIdGenerator;
    private final OpaqueCallbackInjector opaqueCallbackInjector;

    public BuildFinalizer(ConstructorInvokeReplacer replacer, BuildIdGenerator buildIdGenerator, OpaqueCallbackInjector opaqueCallbackInjector) {
        this.replacer = replacer;
        this.buildIdGenerator = buildIdGenerator;
        this.opaqueCallbackInjector = opaqueCallbackInjector;
    }

    @Override
    public Set<String> injectBuildInfoAndInfoPointRegister(File classesDirectory, Collection<String> pastInfoPoints) {
        try {
            byte[] classContents = this.replacer.generateInfoPointRegister(classesDirectory, pastInfoPoints);
            this.buildIdGenerator.update(this.replacer.getInfoPointRegisterClassName(), classContents);
            this.buildIdGenerator.writeBuildInfoClass(classesDirectory);
            this.opaqueCallbackInjector.writeOpaqueCallbacks(classesDirectory);
            return this.replacer.getAllInfoPoints();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

