/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.android.bci;

import com.appdynamics.android.bci.ClassStreamRewriter;
import com.appdynamics.android.bci.ClassUtil;
import com.appdynamics.android.bci.InstrumentationConfig;
import com.appdynamics.android.bci.io.ClassFileRewriter;
import com.appdynamics.android.bci.io.IStreamFactory;
import com.appdynamics.android.logging.BCILogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;

public class Injector {
    private static void usage(String msg) {
        String prog = System.getProperty("sun.java.command");
        System.err.println(prog + ": " + msg);
        System.err.println("usage: java -jar injector.jar <path> [options] [optional libraries...]");
        System.err.println("  options:");
        System.err.println("    -i <file>                    : YML file describing interceptor, can be used multiple times");
        System.err.println("    -x <pattern>                 : Classes to be excluded from injection, can be used multiple times");
        System.err.println("    --enableWebViewCrashReporting: Instrument crash reporting for WebView objects");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            Injector.usage("no arguments?");
        } else {
            File logFileDir = new File(System.getProperty("java.io.tmpdir"), "Appd-androidbci_" + System.currentTimeMillis());
            logFileDir.mkdirs();
            BCILogger.setBciLogger(new BCILogger.MultiLogger(logFileDir){

                @Override
                protected void _log(BCILogger.Level level, String msg, Object ... args) {
                    if (level == BCILogger.Level.INFO) {
                        System.out.println("[INFO] " + String.format(msg, args));
                    }
                }
            });
            InstrumentationConfig config = new InstrumentationConfig();
            ArrayList<URL> urls = new ArrayList<URL>();
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-i")) {
                    if (++i >= args.length) {
                        Injector.usage("-i: requires argument");
                        return;
                    }
                    config.addInterceptorFiles(args[i]);
                    continue;
                }
                if (args[i].equals("-x")) {
                    if (++i >= args.length) {
                        Injector.usage("-x: requires argument");
                        return;
                    }
                    config.addExcludedClasses(args[i]);
                    continue;
                }
                if (args[i].equalsIgnoreCase("--enableWebViewCrashReporting")) {
                    config.setWebViewCallbackCrashReportingEnabled(true);
                    continue;
                }
                urls.add(new File(args[i]).toURI().toURL());
            }
            ClassUtil classUtil = ClassUtil.Factory.createClassUtil(urls.toArray(new URL[0]));
            ClassStreamRewriter streamRewriter = new ClassStreamRewriter(classUtil, config);
            streamRewriter.beginInstrumentation();
            File rootFolder = new File(args[0]);
            if (!rootFolder.isDirectory()) {
                Injector.usage(String.format("path: is not a directory: %s", args[0]));
                return;
            }
            ClassFileRewriter cfr = new ClassFileRewriter(rootFolder, streamRewriter, new IStreamFactory(){

                @Override
                public InputStream getInputStream(File f) throws IOException {
                    return new FileInputStream(f);
                }

                @Override
                public OutputStream getOutputStream(File f) throws IOException {
                    return new FileOutputStream(f);
                }

                @Override
                public JarInputStream getJarInputStream(InputStream is) throws IOException {
                    throw new UnsupportedOperationException("This entry point does not support jar instrumentation; use the ant task instead");
                }

                @Override
                public JarOutputStream getJarOutputStream(OutputStream os, Manifest manifest) throws IOException {
                    throw new UnsupportedOperationException("This entry point does not support jar instrumentation; use the ant task instead");
                }
            });
            try {
                cfr.rewrite();
            }
            finally {
                System.out.println("Logs are available at: " + logFileDir);
                streamRewriter.injectBuildInfoAndInfoPointRegister(rootFolder, Collections.<String>emptyList());
                streamRewriter.endInstrumentation();
            }
        }
    }
}

